/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.protocol.proto.AliasMapProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.AliasMapProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMapProtocol;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AliasMapProtocolServerSideTranslatorPB
implements AliasMapProtocolPB {
    private final InMemoryAliasMapProtocol aliasMap;
    private static final AliasMapProtocolProtos.WriteResponseProto VOID_WRITE_RESPONSE = AliasMapProtocolProtos.WriteResponseProto.newBuilder().build();

    public AliasMapProtocolServerSideTranslatorPB(InMemoryAliasMapProtocol aliasMap) {
        this.aliasMap = aliasMap;
    }

    @Override
    public AliasMapProtocolProtos.WriteResponseProto write(RpcController controller, AliasMapProtocolProtos.WriteRequestProto request) throws ServiceException {
        try {
            FileRegion toWrite = PBHelper.convert(request.getKeyValuePair());
            this.aliasMap.write(toWrite.getBlock(), toWrite.getProvidedStorageLocation());
            return VOID_WRITE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public AliasMapProtocolProtos.ReadResponseProto read(RpcController controller, AliasMapProtocolProtos.ReadRequestProto request) throws ServiceException {
        try {
            Block toRead = PBHelperClient.convert((HdfsProtos.BlockProto)request.getKey());
            Optional<ProvidedStorageLocation> optionalResult = this.aliasMap.read(toRead);
            AliasMapProtocolProtos.ReadResponseProto.Builder builder = AliasMapProtocolProtos.ReadResponseProto.newBuilder();
            if (optionalResult.isPresent()) {
                ProvidedStorageLocation providedStorageLocation = optionalResult.get();
                builder.setValue(PBHelperClient.convert((ProvidedStorageLocation)providedStorageLocation));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public AliasMapProtocolProtos.ListResponseProto list(RpcController controller, AliasMapProtocolProtos.ListRequestProto request) throws ServiceException {
        try {
            HdfsProtos.BlockProto marker = request.getMarker();
            InMemoryAliasMapProtocol.IterationResult iterationResult = marker.isInitialized() ? this.aliasMap.list(Optional.of(PBHelperClient.convert((HdfsProtos.BlockProto)marker))) : this.aliasMap.list(Optional.empty());
            AliasMapProtocolProtos.ListResponseProto.Builder responseBuilder = AliasMapProtocolProtos.ListResponseProto.newBuilder();
            List<FileRegion> fileRegions = iterationResult.getFileRegions();
            List keyValueProtos = fileRegions.stream().map(PBHelper::convert).collect(Collectors.toList());
            responseBuilder.addAllFileRegions(keyValueProtos);
            Optional<Block> nextMarker = iterationResult.getNextBlock();
            nextMarker.map(m -> responseBuilder.setNextMarker(PBHelperClient.convert((Block)m)));
            return responseBuilder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public AliasMapProtocolProtos.BlockPoolResponseProto getBlockPoolId(RpcController controller, AliasMapProtocolProtos.BlockPoolRequestProto req) throws ServiceException {
        try {
            String bpid = this.aliasMap.getBlockPoolId();
            return AliasMapProtocolProtos.BlockPoolResponseProto.newBuilder().setBlockPoolId(bpid).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

