/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.resolve_index;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ResolveIndexItem
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ResolveIndexItem> {
    @Nonnull
    private final List<String> aliases;
    @Nonnull
    private final List<String> attributes;
    @Nullable
    private final String dataStream;
    @Nonnull
    private final String name;
    public static final JsonpDeserializer<ResolveIndexItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexItem::setupResolveIndexItemDeserializer);

    private ResolveIndexItem(Builder builder) {
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.dataStream = builder.dataStream;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static ResolveIndexItem of(Function<Builder, ObjectBuilder<ResolveIndexItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> aliases() {
        return this.aliases;
    }

    @Nonnull
    public final List<String> attributes() {
        return this.attributes;
    }

    @Nullable
    public final String dataStream() {
        return this.dataStream;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartArray();
            for (String item0 : this.aliases) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("attributes");
        generator.writeStartArray();
        for (String item0 : this.attributes) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            generator.write(this.dataStream);
        }
        generator.writeKey("name");
        generator.write(this.name);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupResolveIndexItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "aliases");
        op.add(Builder::attributes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::dataStream, JsonpDeserializer.stringDeserializer(), "data_stream");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.aliases);
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + Objects.hashCode(this.dataStream);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolveIndexItem other = (ResolveIndexItem)o;
        return Objects.equals(this.aliases, other.aliases) && this.attributes.equals(other.attributes) && Objects.equals(this.dataStream, other.dataStream) && this.name.equals(other.name);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ResolveIndexItem> {
        @Nullable
        private List<String> aliases;
        private List<String> attributes;
        @Nullable
        private String dataStream;
        private String name;

        public Builder() {
        }

        private Builder(ResolveIndexItem o) {
            this.aliases = Builder._listCopy(o.aliases);
            this.attributes = Builder._listCopy(o.attributes);
            this.dataStream = o.dataStream;
            this.name = o.name;
        }

        private Builder(Builder o) {
            this.aliases = Builder._listCopy(o.aliases);
            this.attributes = Builder._listCopy(o.attributes);
            this.dataStream = o.dataStream;
            this.name = o.name;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder aliases(List<String> list) {
            this.aliases = Builder._listAddAll(this.aliases, list);
            return this;
        }

        @Nonnull
        public final Builder aliases(String value, String ... values) {
            this.aliases = Builder._listAdd(this.aliases, value, values);
            return this;
        }

        @Nonnull
        public final Builder attributes(List<String> list) {
            this.attributes = Builder._listAddAll(this.attributes, list);
            return this;
        }

        @Nonnull
        public final Builder attributes(String value, String ... values) {
            this.attributes = Builder._listAdd(this.attributes, value, values);
            return this;
        }

        @Nonnull
        public final Builder dataStream(@Nullable String value) {
            this.dataStream = value;
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        @Nonnull
        public ResolveIndexItem build() {
            this._checkSingleUse();
            return new ResolveIndexItem(this);
        }
    }
}

