/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.util;

import com.github.kokorin.jaffree.JaffreeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineIterator
implements Iterator<String> {
    private final BufferedReader reader;
    private String nextLine = null;
    private boolean depleted = false;

    public LineIterator(BufferedReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        if (this.nextLine != null) {
            return true;
        }
        if (this.depleted) {
            return false;
        }
        try {
            this.nextLine = this.reader.readLine();
        }
        catch (IOException e) {
            throw new JaffreeException("Read failed", e);
        }
        if (this.nextLine == null) {
            this.depleted = true;
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more lines");
        }
        String result = this.nextLine;
        this.nextLine = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

