/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.keycloak.common.Version;
import org.keycloak.provider.Provider;

public interface TracingProvider
extends Provider {
    public Span getCurrentSpan();

    public Span startSpan(String var1, String var2);

    default public Span startSpan(Class<?> tracerClass, String spanSuffix) {
        return this.startSpan(tracerClass.getName(), tracerClass.getSimpleName() + "." + spanSuffix);
    }

    public Span startSpan(SpanBuilder var1);

    public void endSpan();

    public void error(Throwable var1);

    public void trace(String var1, String var2, Consumer<Span> var3);

    default public void trace(Class<?> tracerClass, String spanSuffix, Consumer<Span> execution) {
        String className = TracingProvider.prepareClassName(tracerClass);
        this.trace(className, className + "." + spanSuffix, execution);
    }

    private static String prepareClassName(Class<?> tracerClass) {
        int end;
        String className = tracerClass.getSimpleName();
        if (className.isEmpty() && (end = (className = tracerClass.getName()).lastIndexOf(".")) != -1) {
            className = className.substring(end + 1);
        }
        return className;
    }

    public <T> T trace(String var1, String var2, Function<Span, T> var3);

    default public <T> T trace(Class<?> tracerClass, String spanSuffix, Function<Span, T> execution) {
        String className = TracingProvider.prepareClassName(tracerClass);
        return this.trace(className, className + "." + spanSuffix, execution);
    }

    public Tracer getTracer(String var1, String var2);

    default public Tracer getTracer(String name) {
        return this.getTracer(name, Version.VERSION);
    }

    public boolean validateAllSpansEnded();
}

