/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.vault.AbstractVaultProviderFactory;
import org.keycloak.vault.DefaultVaultRawSecret;
import org.keycloak.vault.VaultKeyResolver;
import org.keycloak.vault.VaultProvider;
import org.keycloak.vault.VaultRawSecret;

public abstract class AbstractVaultProvider
implements VaultProvider {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    protected final String realm;
    protected final List<VaultKeyResolver> resolvers;

    public AbstractVaultProvider(String realm, List<VaultKeyResolver> configuredResolvers) {
        this.realm = realm;
        this.resolvers = configuredResolvers;
    }

    public VaultRawSecret obtainSecret(String vaultSecretId) {
        String resolvedKey;
        for (VaultKeyResolver resolver : this.resolvers) {
            if (this.validate(resolver, vaultSecretId, resolvedKey = (String)resolver.apply((Object)this.realm, (Object)vaultSecretId))) continue;
            logger.warnf("Validation failed for secret %s with resolved key %s", (Object)vaultSecretId, (Object)resolvedKey);
            return DefaultVaultRawSecret.forBuffer(Optional.empty());
        }
        for (VaultKeyResolver resolver : this.resolvers) {
            resolvedKey = (String)resolver.apply((Object)this.realm, (Object)vaultSecretId);
            VaultRawSecret secret = this.obtainSecretInternal(resolvedKey);
            if (secret != null && secret.get().isPresent()) {
                return secret;
            }
            this.checkForLegacyKey(resolver, vaultSecretId, resolvedKey);
        }
        return DefaultVaultRawSecret.forBuffer(Optional.empty());
    }

    private void checkForLegacyKey(VaultKeyResolver resolver, String vaultSecretId, String resolvedKey) {
        String legacyKey;
        VaultRawSecret legacySecret;
        if (resolver == AbstractVaultProviderFactory.AvailableResolvers.KEY_ONLY.getVaultKeyResolver() && vaultSecretId.contains("_") && (legacySecret = this.obtainSecretInternal(legacyKey = vaultSecretId.replaceAll("__", "_"))) != null && legacySecret.get().isPresent()) {
            logger.warnf("Secret was found using legacy key '%s'. Please rename the key to '%s' and repeat the action.", (Object)legacyKey, (Object)resolvedKey);
        }
    }

    protected boolean validate(VaultKeyResolver resolver, String key, String resolvedKey) {
        if (key.contains(File.separator)) {
            logger.warnf("Key %s contains invalid file separator character", (Object)key);
            return false;
        }
        return true;
    }

    protected abstract VaultRawSecret obtainSecretInternal(String var1);
}

