#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cassava
version:              0.5.4.0
visibility:           public
id:                   cassava-0.5.4.0-98LDwLZz10l6jrRwSpQAa8
key:                  cassava-0.5.4.0-98LDwLZz10l6jrRwSpQAa8
license:              BSD-3-Clause
copyright:
    (c) 2012 Johan Tibell
    (c) 2012 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           https://github.com/haskell-hvr/cassava
author:               Johan Tibell
homepage:             https://github.com/haskell-hvr/cassava
synopsis:             A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.

    @cassava@'\''s API includes support for

    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")

    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:

    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"

    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.

category:             Text, Web, CSV
abi:                  de417a3b73d7583bf935ce9affb38d48
exposed:              True
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming

hidden-modules:
    Data.Csv.Conversion Data.Csv.Conversion.Internal Data.Csv.Encoding
    Data.Csv.Types Data.Csv.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/cassava-0.5.4.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cassava-0.5.4.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cassava-0.5.4.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cassava
hs-libraries:         HScassava-0.5.4.0-98LDwLZz10l6jrRwSpQAa8
depends:
    Only-0.1-2ALIOaFTuVl17VyQ33BnR1 array-0.5.4.0
    attoparsec-0.14.4-H9Y4iLHDqcP1CPr5BByOUl base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.4.0-5SoCNaysfySGuPwu0aljBu
    scientific-0.3.8.0-IYXDhI1DsbO4omE9hYw4Ya text-2.0.2
    text-short-0.1.6-Kv7P2ZX0BeHFix0EyOc2uN transformers-0.5.6.2
    unordered-containers-0.2.20-AeV3HTkHtCc6BQ9fzLSSB8
    vector-0.13.2.0-52P7Ozt5w3I6hi4WvheJB9

haddock-interfaces:   /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html:         /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

