#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              2.3
visibility:           public
id:                   brick-2.3-1WKVOYVV1Ab5SnHAwWixRr
key:                  brick-2.3-1WKVOYVV1Ab5SnHAwWixRr
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2023
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  6dacac8b9daba75c9b2111c8121c7843
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Keybindings Brick.Keybindings.KeyConfig
    Brick.Keybindings.KeyDispatcher Brick.Keybindings.KeyEvents
    Brick.Keybindings.Parse Brick.Keybindings.Pretty Brick.Main
    Brick.Themes Brick.Types Brick.Util Brick.Widgets.Border
    Brick.Widgets.Border.Style Brick.Widgets.Center Brick.Widgets.Core
    Brick.Widgets.Dialog Brick.Widgets.Edit Brick.Widgets.FileBrowser
    Brick.Widgets.List Brick.Widgets.ProgressBar Brick.Widgets.Table
    Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.EventM
    Brick.Types.Internal Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/brick-2.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/brick-2.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/brick-2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick
hs-libraries:         HSbrick-2.3-1WKVOYVV1Ab5SnHAwWixRr
depends:
    base-4.17.2.1 bimap-0.5.0-HpogrP7wXwF795hsRRXkc0
    bytestring-0.11.5.3 config-ini-0.2.7.0-LuQGNnCFYPWEt8Y05dTZAq
    containers-0.6.7 data-clist-0.2-HKL1mIJQUgnDFtFwoeaOLH
    deepseq-1.4.8.0 directory-1.3.7.1 exceptions-0.10.5
    filepath-1.4.2.2 microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2 stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2
    text-zipper-0.13-UpVt8fohmnErhlgSiPTk5
    unix-compat-0.7.4.1-AZ3QvicZDsfFka2eKBF0EH
    vector-0.13.2.0-B3Rnif6nhJNLHPAZlzHp2g
    vty-6.2-6gEjnHVANSpBUfLcghnlQb
    vty-crossplatform-0.4.0.0-XbRtYdps8j4EIOGFDjUb7
    word-wrap-0.5-XZ9C1zP6mLCLFcpvYzK3k

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

