// Generated by gmmproc 2.85.0 -- DO NOT MODIFY!
#ifndef _GTKMM_GRAPHICSOFFLOAD_H
#define _GTKMM_GRAPHICSOFFLOAD_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/enums.h>
#include <gtkmm/widget.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API GraphicsOffload_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A widget that allows to bypass gsk rendering for its child by passing
 * the content directly to the compositor.
 *
 * Graphics offload is an optimization to reduce overhead and battery use that is
 * most useful for video content. It only works on some platforms and in certain
 * situations. GTK will automatically fall back to normal rendering if it doesn't.
 *
 * Graphics offload is most efficient if there are no controls drawn on top of the
 * video content.
 *
 * You should consider using graphics offload for your main widget if it shows
 * frequently changing content (such as a video, or a VM display) and you provide
 * the content in the form of dmabuf textures (see Gdk::DmabufTextureBuilder),
 * in particular if it may be fullscreen.
 *
 * Numerous factors can prohibit graphics offload:
 *
 * - Unsupported platforms. Currently, graphics offload only works on Linux with Wayland.
 *
 * - Clipping, such as rounded corners that cause the video content to not be rectangular
 *
 * - Unsupported dmabuf formats (see Gdk::Display::get_dmabuf_formats())
 *
 * - Translucent video content (content with an alpha channel, even if it isn't used)
 *
 * - Transforms that are more complex than translations and scales
 *
 * - Filters such as opacity, grayscale or similar
 *
 * To investigate problems related graphics offload, GTK offers debug flags to print
 * out information about graphics offload and dmabuf use:
 *
 *     GDK_DEBUG=offload
 *     GDK_DEBUG=dmabuf
 *
 * The GTK inspector provides a visual debugging tool for graphics offload.
 *
 * @ingroup Widgets
 *
 * @newin{4,14}
 */

class GTKMM_API GraphicsOffload : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef GraphicsOffload CppObjectType;
  typedef GraphicsOffload_Class CppClassType;
  typedef GtkGraphicsOffload BaseObjectType;
  typedef GtkGraphicsOffloadClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  GraphicsOffload(GraphicsOffload&& src) noexcept;
  GraphicsOffload& operator=(GraphicsOffload&& src) noexcept;

  // noncopyable
  GraphicsOffload(const GraphicsOffload&) = delete;
  GraphicsOffload& operator=(const GraphicsOffload&) = delete;

  ~GraphicsOffload() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend GTKMM_API class GraphicsOffload_Class;
  static CppClassType graphicsoffload_class_;

protected:
  explicit GraphicsOffload(const Glib::ConstructParams& construct_params);
  explicit GraphicsOffload(GtkGraphicsOffload* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkGraphicsOffload*       gobj()       { return reinterpret_cast<GtkGraphicsOffload*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkGraphicsOffload* gobj() const { return reinterpret_cast<GtkGraphicsOffload*>(gobject_); }

private:

     
public:
  GraphicsOffload();

  
  /** Sets the child of @a self.
   * 
   * @newin{4,14}
   * 
   * @param child The child widget.
   */
  void set_child(Widget& child);
  void unset_child();
  
  /** Gets the child of @a self.
   * 
   * @newin{4,14}
   * 
   * @return The child widget.
   */
  Widget* get_child();
  
  /** Gets the child of @a self.
   * 
   * @newin{4,14}
   * 
   * @return The child widget.
   */
  const Widget* get_child() const;

  
  /** Sets whether this GtkGraphicsOffload widget will attempt
   * to offload the content of its child widget.
   * 
   * @newin{4,14}
   * 
   * @param enabled Whether to enable offload.
   */
  void set_enabled(GraphicsOffloadEnabled enabled);
  
  /** Returns whether offload is enabled for @a self.
   * 
   * @newin{4,14}
   * 
   * @return Whether offload is enabled.
   */
  GraphicsOffloadEnabled get_enabled() const;

  
  /** Sets whether this GtkGraphicsOffload widget will draw a black
   * background.
   * 
   * A main use case for this is **_letterboxing_** where black bars are
   * visible next to the content if the aspect ratio of the content does
   * not match the dimensions of the monitor.
   * 
   * Using this property for letterboxing instead of CSS allows compositors
   * to show content with maximum efficiency, using direct scanout to avoid
   * extra copies in the compositor.
   * 
   * On Wayland, this is implemented using the
   * [single-pixel buffer](https://wayland.app/protocols/single-pixel-buffer-v1)
   * protocol.
   * 
   * @newin{4,16}
   * 
   * @param value Whether to draw a black background behind the content.
   */
  void set_black_background(bool value =  true);
  
  /** Returns whether the widget draws a black background.
   * 
   * See set_black_background().
   * 
   * @newin{4,16}
   * 
   * @return <tt>true</tt> if black background is drawn.
   */
  bool get_black_background() const;

  /** The child widget.
   * 
   * @newin{4,14}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_child() ;

/** The child widget.
   * 
   * @newin{4,14}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_child() const;

  /** Whether graphics offload is enabled.
   * 
   * @newin{4,14}
   *
   * Default value: Gtk::GraphicsOffloadEnabled::ENABLED
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< GraphicsOffloadEnabled > property_enabled() ;

/** Whether graphics offload is enabled.
   * 
   * @newin{4,14}
   *
   * Default value: Gtk::GraphicsOffloadEnabled::ENABLED
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< GraphicsOffloadEnabled > property_enabled() const;

  /** Whether to draw a black background.
   * 
   * @newin{4,16}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_black_background() ;

/** Whether to draw a black background.
   * 
   * @newin{4,16}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_black_background() const;


  // There are no signals or vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} //namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::GraphicsOffload
   */
  GTKMM_API
  Gtk::GraphicsOffload* wrap(GtkGraphicsOffload* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_GRAPHICSOFFLOAD_H */

