/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemMarker;
import org.jetbrains.kotlin.resolve.calls.inference.components.InferenceLogger;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinder;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintSystemError;
import org.jetbrains.kotlin.resolve.calls.inference.model.InitialConstraint;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0016\u0018\u0000 X2\u00020\u00012\u00020\u0002:\fMNOPQRSTUVWXB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0014\u0010\u0015\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0018\u0010*\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010+\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0018\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0018\u0010/\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0018\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u0002022\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0014\u00103\u001a\u000204*\u0002022\u0006\u00105\u001a\u000202H\u0002J\u0016\u00103\u001a\u000204*\u0002062\b\u00107\u001a\u0004\u0018\u000106H\u0002J\u000e\u00108\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u000209J0\u0010?\u001a\u0002H@\"\u0004\b\u0000\u0010@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00180;2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H@0CH\u0082\b\u00a2\u0006\u0002\u0010DJ)\u0010E\u001a\u0002H@\"\u0004\b\u0000\u0010@2\u0006\u0010\u001e\u001a\u00020\u00172\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H@0CH\u0016\u00a2\u0006\u0002\u0010FJA\u0010G\u001a\u0002H@\"\u0004\b\u0000\u0010@2\u0006\u0010H\u001a\u00020\u001b2\u0006\u0010I\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u001c2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H@0CH\u0016\u00a2\u0006\u0002\u0010LR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0019\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a\u0012\u0004\u0012\u00020\u00180\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\tR \u0010:\u001a\b\u0012\u0004\u0012\u00020\u00180;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\t\"\u0004\b=\u0010>\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/InferenceLogger;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "<init>", "()V", "topLevelElements", "", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockElement;", "getTopLevelElements", "()Ljava/util/List;", "currentSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemMarker;", "currentBlock", "systemToKnownBlock", "", "systemToCandidate", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner$Candidate;", "prepareProperBlock", "", "system", "updateCurrentSystem", "register", "initialConstraintToKnownElement", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/InitialConstraint;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$ConstraintElement;", "variableConstraintToKnownElement", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "cachedElementFor", "constraint", "variable", "currentCandidate", "logCandidate", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "logStage", "name", "", "currentBlockItemElements", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockItemElement;", "getCurrentBlockItemElements", "logInitial", "log", "logError", "error", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintSystemError;", "logNewVariable", "logReadiness", "fixationLog", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/InferenceLogger$FixationLogRecord;", "isSimilarTo", "", "record", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/InferenceLogger$FixationLogVariableInfo;", "info", "assignFixedToInFixationLogs", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionContext;", "origins", "", "getOrigins", "setOrigins", "(Ljava/util/List;)V", "withOriginatingElements", "T", "elements", "block", "Lkotlin/Function0;", "(Ljava/util/List;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withOrigin", "(Lorg/jetbrains/kotlin/resolve/calls/inference/model/InitialConstraint;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withOrigins", "variable1", "constraint1", "variable2", "constraint2", "(Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "LoggingElement", "Call", "BlockOwner", "BlockElement", "BlockItemElement", "NewVariableElement", "ErrorElement", "ConstraintElement", "InitialConstraintElement", "VariableConstraintElement", "FixationLogRecordElement", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirInferenceLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInferenceLogger.kt\norg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,282:1\n229#1,7:300\n229#1,7:307\n1#2:283\n1#2:294\n1617#3,9:284\n1869#3:293\n1870#3:295\n1626#3:296\n774#3:297\n865#3,2:298\n*S KotlinDebug\n*F\n+ 1 FirInferenceLogger.kt\norg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger\n*L\n239#1:300,7\n252#1:307,7\n182#1:294\n182#1:284,9\n182#1:293\n182#1:295\n182#1:296\n212#1:297\n212#1:298,2\n*E\n"})
public class FirInferenceLogger
extends InferenceLogger
implements FirSessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<BlockElement> topLevelElements = new ArrayList();
    @Nullable
    private ConstraintSystemMarker currentSystem;
    private BlockElement currentBlock;
    @NotNull
    private final Map<ConstraintSystemMarker, BlockElement> systemToKnownBlock = new LinkedHashMap();
    @NotNull
    private final Map<ConstraintSystemMarker, BlockOwner.Candidate> systemToCandidate = new LinkedHashMap();
    @NotNull
    private final Map<InitialConstraint, ConstraintElement> initialConstraintToKnownElement = new LinkedHashMap();
    @NotNull
    private final Map<Pair<TypeVariableMarker, Constraint>, ConstraintElement> variableConstraintToKnownElement = new LinkedHashMap();
    @Nullable
    private BlockOwner.Candidate currentCandidate;
    @NotNull
    private List<? extends ConstraintElement> origins = CollectionsKt.emptyList();
    @NotNull
    private static final Regex fqNameRegex = new Regex("(?:\\w+\\.)*(\\w+)@\\w+");

    @NotNull
    public final List<BlockElement> getTopLevelElements() {
        return this.topLevelElements;
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareProperBlock(ConstraintSystemMarker system) {
        void $this$prepareProperBlock_u24lambda_u240;
        BlockElement blockElement;
        if (Intrinsics.areEqual((Object)system, (Object)this.currentSystem)) {
            return;
        }
        this.updateCurrentSystem(system);
        BlockElement knownPreviousBlock = this.systemToKnownBlock.get(system);
        if (knownPreviousBlock == null || this.currentCandidate == null) {
            throw new IllegalStateException("UNKNOWN SYSTEM".toString());
        }
        String nextBlockTitle = "Continue " + knownPreviousBlock.getName();
        BlockOwner.Candidate candidate2 = this.currentCandidate;
        BlockElement blockElement2 = blockElement = new BlockElement(nextBlockTitle, null, candidate2 != null ? (BlockOwner)candidate2 : (BlockOwner)BlockOwner.Unknown.INSTANCE, 2, null);
        FirInferenceLogger firInferenceLogger = this;
        boolean bl = false;
        this.register((BlockElement)$this$prepareProperBlock_u24lambda_u240, system);
        firInferenceLogger.currentBlock = blockElement;
    }

    private final void updateCurrentSystem(ConstraintSystemMarker system) {
        if (Intrinsics.areEqual((Object)system, (Object)this.currentSystem)) {
            return;
        }
        this.currentSystem = system;
        this.currentCandidate = this.systemToCandidate.get(system);
    }

    private final void register(BlockElement $this$register, ConstraintSystemMarker system) {
        Object object = (BlockElement)CollectionsKt.lastOrNull(this.topLevelElements);
        boolean bl = object != null && (object = ((BlockElement)object).getItems()) != null ? object.isEmpty() : false;
        if (bl) {
            CollectionsKt.removeLast(this.topLevelElements);
        }
        this.systemToKnownBlock.put(system, $this$register);
        ((Collection)this.topLevelElements).add($this$register);
    }

    private final ConstraintElement cachedElementFor(InitialConstraint constraint) {
        ConstraintElement constraintElement = this.initialConstraintToKnownElement.get(constraint);
        if (constraintElement == null) {
            throw new IllegalStateException(("This constraint has not yet been logged: " + constraint).toString());
        }
        return constraintElement;
    }

    private final ConstraintElement cachedElementFor(TypeVariableMarker variable, Constraint constraint) {
        ConstraintElement constraintElement = this.variableConstraintToKnownElement.get(TuplesKt.to((Object)variable, (Object)constraint));
        if (constraintElement == null) {
            throw new IllegalStateException(("This constraint has not yet been logged: " + variable + " with " + constraint).toString());
        }
        return constraintElement;
    }

    public final void logCandidate(@NotNull Candidate candidate2) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        BlockOwner.Candidate candidate3 = this.currentCandidate;
        if ((candidate3 != null ? candidate3.getCandidate() : null) != candidate2) {
            BlockOwner.Candidate candidateOwner = new BlockOwner.Candidate(candidate2);
            this.systemToCandidate.put(candidate2.getSystem(), candidateOwner);
            this.currentCandidate = candidateOwner;
            this.currentSystem = candidate2.getSystem();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logStage(@NotNull String name2, @NotNull ConstraintSystemMarker system) {
        void $this$logStage_u24lambda_u240;
        BlockElement blockElement;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        this.updateCurrentSystem(system);
        BlockOwner.Candidate candidate2 = this.currentCandidate;
        BlockElement blockElement2 = blockElement = new BlockElement(name2, null, candidate2 != null ? (BlockOwner)candidate2 : (BlockOwner)BlockOwner.Unknown.INSTANCE, 2, null);
        FirInferenceLogger firInferenceLogger = this;
        boolean bl = false;
        this.register((BlockElement)$this$logStage_u24lambda_u240, system);
        firInferenceLogger.currentBlock = blockElement;
    }

    private final List<BlockItemElement> getCurrentBlockItemElements() {
        BlockElement blockElement = this.currentBlock;
        if (blockElement == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentBlock");
            blockElement = null;
        }
        return blockElement.getItems();
    }

    @Override
    public void logInitial(@NotNull InitialConstraint constraint, @NotNull ConstraintSystemMarker system) {
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        this.prepareProperBlock(system);
        InitialConstraintElement element = new InitialConstraintElement(FirInferenceLogger.formatConstraint(constraint), Companion.sanitizeFqNames(constraint.getPosition().toString()));
        this.initialConstraintToKnownElement.putIfAbsent(constraint, element);
        ((Collection)this.getCurrentBlockItemElements()).add(element);
    }

    @Override
    public void log(@NotNull TypeVariableMarker variable, @NotNull Constraint constraint, @NotNull ConstraintSystemMarker system) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        this.prepareProperBlock(system);
        VariableConstraintElement element = new VariableConstraintElement(FirInferenceLogger.formatConstraint(variable, constraint), this.origins);
        this.variableConstraintToKnownElement.putIfAbsent((Pair<TypeVariableMarker, Constraint>)TuplesKt.to((Object)variable, (Object)constraint), element);
        ((Collection)this.getCurrentBlockItemElements()).add(element);
    }

    @Override
    public void logError(@NotNull ConstraintSystemError error, @NotNull ConstraintSystemMarker system) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        this.prepareProperBlock(system);
        this.getCurrentBlockItemElements().add(new ErrorElement(error));
    }

    @Override
    public void logNewVariable(@NotNull TypeVariableMarker variable, @NotNull ConstraintSystemMarker system) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        this.prepareProperBlock(system);
        this.getCurrentBlockItemElements().add(new NewVariableElement(variable));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logReadiness(@NotNull InferenceLogger.FixationLogRecord fixationLog, @NotNull ConstraintSystemMarker system) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fixationLog, (String)"fixationLog");
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        this.prepareProperBlock(system);
        Iterable $this$mapNotNull$iv = this.getCurrentBlockItemElements();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            InferenceLogger.FixationLogRecord it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BlockItemElement it = (BlockItemElement)element$iv$iv;
            boolean bl2 = false;
            FixationLogRecordElement fixationLogRecordElement = it instanceof FixationLogRecordElement ? (FixationLogRecordElement)it : null;
            if ((fixationLogRecordElement != null ? fixationLogRecordElement.getRecord() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fixationLogs = (List)destination$iv$iv;
        if (fixationLogs.isEmpty() || !this.isSimilarTo((InferenceLogger.FixationLogRecord)CollectionsKt.last((List)fixationLogs), fixationLog)) {
            this.getCurrentBlockItemElements().add(new FixationLogRecordElement(fixationLog));
        }
    }

    private final boolean isSimilarTo(InferenceLogger.FixationLogRecord $this$isSimilarTo, InferenceLogger.FixationLogRecord record) {
        if (record.getChosen() != $this$isSimilarTo.getChosen()) {
            return false;
        }
        if (record.getMap().size() != $this$isSimilarTo.getMap().size()) {
            return false;
        }
        for (Map.Entry<TypeVariableMarker, InferenceLogger.FixationLogVariableInfo> entry : record.getMap().entrySet()) {
            TypeVariableMarker variable = entry.getKey();
            InferenceLogger.FixationLogVariableInfo info = entry.getValue();
            if (this.isSimilarTo(info, $this$isSimilarTo.getMap().get(variable))) continue;
            return false;
        }
        return true;
    }

    private final boolean isSimilarTo(InferenceLogger.FixationLogVariableInfo $this$isSimilarTo, InferenceLogger.FixationLogVariableInfo info) {
        if (info == null) {
            return false;
        }
        if ($this$isSimilarTo.getReadiness() != info.getReadiness()) {
            return false;
        }
        if ($this$isSimilarTo.getConstraints().size() != info.getConstraints().size()) {
            return false;
        }
        int n2 = $this$isSimilarTo.getConstraints().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if ($this$isSimilarTo.getConstraints().get(i2) == info.getConstraints().get(i2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void assignFixedToInFixationLogs(@NotNull ConstraintSystemCompletionContext system) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        this.prepareProperBlock(system);
        for (Map.Entry<TypeConstructorMarker, KotlinTypeMarker> entry : system.getFixedTypeVariables().entrySet()) {
            void $this$filterTo$iv$iv;
            TypeConstructorMarker constructor = entry.getKey();
            KotlinTypeMarker type = entry.getValue();
            if (system.getAllTypeVariables().get(constructor) == null) continue;
            Iterable $this$filter$iv = this.topLevelElements;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BlockElement it = (BlockElement)element$iv$iv;
                boolean bl = false;
                BlockOwner blockOwner = it.getOwner();
                Object object = blockOwner instanceof BlockOwner.Candidate ? (BlockOwner.Candidate)blockOwner : null;
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((BlockOwner.Candidate)object).getCandidate()) != null ? ((Candidate)object).getSystem() : null), (Object)system)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List relevantBlocks = (List)destination$iv$iv;
            for (BlockElement block : relevantBlocks) {
                for (BlockItemElement element : block.getItems()) {
                    TypeVariableMarker typeVariable;
                    InferenceLogger.FixationLogRecord log2;
                    if (!(element instanceof FixationLogRecordElement) || (log2 = ((FixationLogRecordElement)element).getRecord()).getChosen() != typeVariable) continue;
                    InferenceLogger.FixationLogVariableInfo fixationLogVariableInfo = log2.getMap().get(typeVariable);
                    if ((fixationLogVariableInfo != null ? fixationLogVariableInfo.getReadiness() : null) == VariableFixationFinder.TypeVariableFixationReadiness.FORBIDDEN) continue;
                    log2.setFixedTo(type);
                }
            }
        }
    }

    @NotNull
    public final List<ConstraintElement> getOrigins() {
        return this.origins;
    }

    public final void setOrigins(@NotNull List<? extends ConstraintElement> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.origins = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <T> T withOrigin(@NotNull InitialConstraint constraint, @NotNull Function0<? extends T> block) {
        Object object;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        FirInferenceLogger firInferenceLogger = this;
        List elements$iv = CollectionsKt.listOf((Object)this.cachedElementFor(constraint));
        boolean $i$f$withOriginatingElements = false;
        List<? extends ConstraintElement> oldOrigins$iv = this_$iv.origins;
        try {
            this_$iv.origins = elements$iv;
            object = block.invoke();
        }
        finally {
            this_$iv.origins = oldOrigins$iv;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <T> T withOrigins(@NotNull TypeVariableMarker variable1, @NotNull Constraint constraint1, @NotNull TypeVariableMarker variable2, @NotNull Constraint constraint2, @NotNull Function0<? extends T> block) {
        Object object;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)variable1, (String)"variable1");
        Intrinsics.checkNotNullParameter((Object)constraint1, (String)"constraint1");
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable2");
        Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint2");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Object object2 = new ConstraintElement[]{this.cachedElementFor(variable1, constraint1), this.cachedElementFor(variable2, constraint2)};
        List elements = CollectionsKt.listOf((Object[])object2);
        object2 = this;
        List elements$iv = elements;
        boolean $i$f$withOriginatingElements = false;
        List<? extends ConstraintElement> oldOrigins$iv = this_$iv.origins;
        try {
            this_$iv.origins = elements$iv;
            object = block.invoke();
        }
        finally {
            this_$iv.origins = oldOrigins$iv;
        }
        return (T)object;
    }

    @JvmStatic
    @NotNull
    protected static final String formatConstraint(@NotNull InitialConstraint constraint) {
        return Companion.formatConstraint(constraint);
    }

    @JvmStatic
    @NotNull
    protected static final String formatConstraint(@NotNull TypeVariableMarker variable, @NotNull Constraint constraint) {
        return Companion.formatConstraint(variable, constraint);
    }

    @JvmStatic
    @NotNull
    public static final String sanitizeFqNames(@NotNull String string) {
        return Companion.sanitizeFqNames(string);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$LoggingElement;", "name", "", "items", "", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockItemElement;", "owner", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner;)V", "getName", "()Ljava/lang/String;", "getItems", "()Ljava/util/List;", "getOwner", "()Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner;", "resolve"})
    public static final class BlockElement
    extends LoggingElement {
        @NotNull
        private final String name;
        @NotNull
        private final List<BlockItemElement> items;
        @NotNull
        private final BlockOwner owner;

        public BlockElement(@NotNull String name2, @NotNull List<BlockItemElement> items, @NotNull BlockOwner owner) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(null);
            this.name = name2;
            this.items = items;
            this.owner = owner;
        }

        public /* synthetic */ BlockElement(String string, List list, BlockOwner blockOwner, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                list = new ArrayList();
            }
            this(string, list, blockOwner);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<BlockItemElement> getItems() {
            return this.items;
        }

        @NotNull
        public final BlockOwner getOwner() {
            return this.owner;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\u0004\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockItemElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$LoggingElement;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$ConstraintElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$ErrorElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$FixationLogRecordElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$NewVariableElement;", "resolve"})
    public static abstract class BlockItemElement
    extends LoggingElement {
        private BlockItemElement() {
            super(null);
        }

        public /* synthetic */ BlockItemElement(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner;", "", "<init>", "()V", "Candidate", "Unknown", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner$Candidate;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner$Unknown;", "resolve"})
    public static abstract class BlockOwner {
        private BlockOwner() {
        }

        public /* synthetic */ BlockOwner(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner$Candidate;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;)V", "getCandidate", "()Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "owningCall", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$Call;", "getOwningCall", "()Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$Call;", "resolve"})
        public static final class Candidate
        extends BlockOwner {
            @NotNull
            private final org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate candidate;
            @NotNull
            private final Call owningCall;

            public Candidate(@NotNull org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate candidate2) {
                Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
                super(null);
                this.candidate = candidate2;
                this.owningCall = new Call(this.candidate.getCallInfo().getCallSite(), null, 2, null);
            }

            @NotNull
            public final org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate getCandidate() {
                return this.candidate;
            }

            @NotNull
            public final Call getOwningCall() {
                return this.owningCall;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner$Unknown;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockOwner;", "<init>", "()V", "resolve"})
        public static final class Unknown
        extends BlockOwner {
            @NotNull
            public static final Unknown INSTANCE = new Unknown();

            private Unknown() {
                super(null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$Call;", "", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "render", "", "<init>", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/String;)V", "getFir", "()Lorg/jetbrains/kotlin/fir/FirElement;", "getRender", "()Ljava/lang/String;", "resolve"})
    public static final class Call {
        @NotNull
        private final FirElement fir;
        @NotNull
        private final String render;

        public Call(@NotNull FirElement fir, @NotNull String render) {
            Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
            Intrinsics.checkNotNullParameter((Object)render, (String)"render");
            this.fir = fir;
            this.render = render;
        }

        public /* synthetic */ Call(FirElement firElement, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string = UtilsKt.render(firElement);
            }
            this(firElement, string);
        }

        @NotNull
        public final FirElement getFir() {
            return this.fir;
        }

        @NotNull
        public final String getRender() {
            return this.render;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0005J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\nH\u0005J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0007R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$Companion;", "", "<init>", "()V", "formatConstraint", "", "constraint", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/InitialConstraint;", "variable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "fqNameRegex", "Lkotlin/text/Regex;", "sanitizeFqNames", "string", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        protected final String formatConstraint(@NotNull InitialConstraint constraint) {
            String string;
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            switch (WhenMappings.$EnumSwitchMapping$0[constraint.getConstraintKind().ordinal()]) {
                case 1: {
                    string = constraint.getA() + " <: " + constraint.getB();
                    break;
                }
                case 2: {
                    string = constraint.getB() + " <: " + constraint.getA();
                    break;
                }
                case 3: {
                    string = constraint.getA() + " == " + constraint.getB();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @JvmStatic
        @NotNull
        protected final String formatConstraint(@NotNull TypeVariableMarker variable, @NotNull Constraint constraint) {
            String string;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            switch (WhenMappings.$EnumSwitchMapping$0[constraint.getKind().ordinal()]) {
                case 2: {
                    string = constraint.getType() + " <: " + variable;
                    break;
                }
                case 1: {
                    string = variable + " <: " + constraint.getType();
                    break;
                }
                case 3: {
                    string = variable + " == " + constraint.getType();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String sanitizeFqNames(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            CharSequence charSequence = string;
            Regex regex = fqNameRegex;
            String string2 = "$1";
            return regex.replace(charSequence, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConstraintKind.values().length];
                try {
                    nArray[ConstraintKind.UPPER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstraintKind.LOWER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstraintKind.EQUALITY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0017\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$ConstraintElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockItemElement;", "origins", "", "<init>", "(Ljava/util/List;)V", "getOrigins", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$InitialConstraintElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$VariableConstraintElement;", "resolve"})
    public static abstract class ConstraintElement
    extends BlockItemElement {
        @NotNull
        private final List<ConstraintElement> origins;

        private ConstraintElement(List<? extends ConstraintElement> origins) {
            super(null);
            this.origins = origins;
        }

        @NotNull
        public final List<ConstraintElement> getOrigins() {
            return this.origins;
        }

        public /* synthetic */ ConstraintElement(List origins, DefaultConstructorMarker $constructor_marker) {
            this(origins);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$ErrorElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockItemElement;", "error", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintSystemError;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintSystemError;)V", "getError", "()Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintSystemError;", "resolve"})
    public static final class ErrorElement
    extends BlockItemElement {
        @NotNull
        private final ConstraintSystemError error;

        public ErrorElement(@NotNull ConstraintSystemError error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(null);
            this.error = error;
        }

        @NotNull
        public final ConstraintSystemError getError() {
            return this.error;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$FixationLogRecordElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockItemElement;", "record", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/InferenceLogger$FixationLogRecord;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/InferenceLogger$FixationLogRecord;)V", "getRecord", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/InferenceLogger$FixationLogRecord;", "resolve"})
    public static final class FixationLogRecordElement
    extends BlockItemElement {
        @NotNull
        private final InferenceLogger.FixationLogRecord record;

        public FixationLogRecordElement(@NotNull InferenceLogger.FixationLogRecord record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            super(null);
            this.record = record;
        }

        @NotNull
        public final InferenceLogger.FixationLogRecord getRecord() {
            return this.record;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$InitialConstraintElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$ConstraintElement;", "constraint", "", "position", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getConstraint", "()Ljava/lang/String;", "getPosition", "resolve"})
    public static final class InitialConstraintElement
    extends ConstraintElement {
        @NotNull
        private final String constraint;
        @NotNull
        private final String position;

        public InitialConstraintElement(@NotNull String constraint, @NotNull String position) {
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            super(CollectionsKt.emptyList(), null);
            this.constraint = constraint;
            this.position = position;
        }

        @NotNull
        public final String getConstraint() {
            return this.constraint;
        }

        @NotNull
        public final String getPosition() {
            return this.position;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$LoggingElement;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockItemElement;", "resolve"})
    public static abstract class LoggingElement {
        private LoggingElement() {
        }

        public /* synthetic */ LoggingElement(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$NewVariableElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$BlockItemElement;", "variable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "<init>", "(Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;)V", "getVariable", "()Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "resolve"})
    public static final class NewVariableElement
    extends BlockItemElement {
        @NotNull
        private final TypeVariableMarker variable;

        public NewVariableElement(@NotNull TypeVariableMarker variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            super(null);
            this.variable = variable;
        }

        @NotNull
        public final TypeVariableMarker getVariable() {
            return this.variable;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$VariableConstraintElement;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceLogger$ConstraintElement;", "constraint", "", "origins", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getConstraint", "()Ljava/lang/String;", "resolve"})
    public static final class VariableConstraintElement
    extends ConstraintElement {
        @NotNull
        private final String constraint;

        public VariableConstraintElement(@NotNull String constraint, @NotNull List<? extends ConstraintElement> origins) {
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            Intrinsics.checkNotNullParameter(origins, (String)"origins");
            super(origins, null);
            this.constraint = constraint;
        }

        @NotNull
        public final String getConstraint() {
            return this.constraint;
        }
    }
}

