#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-GX8J3ZeBKHpAXupEgLl19Z
key:                  glirc-2.40.1-GX8J3ZeBKHpAXupEgLl19Z
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  54ef1bc0fe0393532163a43714d3c8e7
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-GX8J3ZeBKHpAXupEgLl19Z
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-F3r0Xz47iXjBWH2gq0bEiO
    async-2.2.5-J9xl5BKgt0u6YsIOuQfrTS
    attoparsec-0.14.4-8oph4y3j0I1GXQUqU3wi8s base-4.17.2.1
    base64-bytestring-1.2.1.0-AvS7geCgwfzr74cccAlCm bytestring-0.11.5.3
    config-schema-1.3.0.0-JIN6UUNvLdKG6BhZZDGVkE
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-BIvIGwZhKtx8Gzat7LXert directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-5M2ZFkfFDlvJ7BmjujlzBX
    githash-0.1.6.3-5O9G7FreM7sKSaKcSAvTo5
    hashable-1.4.7.0-GgneweRn8eTKcMM4X3n956
    hookup-0.8-DCpeIVtdZEQJbWOC9Q7rBO
    irc-core-2.12-3HHAppkeoJtFBmi8bUtzzN
    kan-extensions-5.2.7-4rI9ZgSSrzN9aYmAB3XbgC
    lens-5.3.2-Do7BRGZKCykCgu16LW7xBK
    network-3.1.4.0-5tdSDQBC1SF9do6vOgsoy3
    psqueues-0.2.8.2-CoUfkANiQXKAV1OLmPGZmU
    random-1.2.1.3-Kx84bR0MhuXELN1ev6GdTW
    regex-tdfa-1.3.2.4-6Wgi5UAwR4D9inZoGIf9gY
    semigroupoids-6.0.1-KCG1rdxHmnQC2yfRp1443g
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-HiZOSEuKrNfKbzH9NOPbSo
    unix-2.7.3 unordered-containers-0.2.20-2N1fR83O3bC5qS2nrjaL2B
    vector-0.13.2.0-EQFZws9ZIK8A2ESM3MR23n
    vty-6.2-EvJE6X8MnCpDyOAMlt70to

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

