#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-Al0fvZ3ypV694NsccLnKAS
key:                  glirc-2.40.1-Al0fvZ3ypV694NsccLnKAS
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  027054a2832efdee5f559c10a36d7689
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-Al0fvZ3ypV694NsccLnKAS
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-AojKwhvEWDdFvrcG1JWLeX
    async-2.2.5-13mgd2n56qe7oct6GfBbZY
    attoparsec-0.14.4-2LtDsLmLe3yKhxR8c5Iii0 base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    bytestring-0.11.5.3 config-schema-1.3.0.0-Bihf08XL1Jg7gaxhydtHj3
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-BAu4O23l3NjGSZEZbJSk3C directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-L6IFLTK1Mi66tRzvv6UvnV
    githash-0.1.6.3-K71CsNKxHJsKZNt2TTDu6a
    hashable-1.4.4.0-6tleuNdu8X41J3b2E1oOOY
    hookup-0.8-9fuScXvgeNV1HoEKZHQfOI
    irc-core-2.12-8u1lGx28Qni3DygaXmWszg
    kan-extensions-5.2.7-B7sMNvxhXLRF4WiW38pwEY
    lens-5.3.1-1dHHf9jtSMJ2j1NVow6adv
    network-3.1.4.0-HEqaUi724nxGs7WtLdNH8M
    psqueues-0.2.8.2-EcKDMoPiuGZ5ujxsTQvKiO
    random-1.2.1.3-1kyQGGmKWocERAlRbbTx7C
    regex-tdfa-1.3.2.4-AZwqaFit2cg4MrWLIhNcyO
    semigroupoids-6.0.1-77kKp314gaoHAvgGjZ9Eia
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-HPRtWfraHBZxZoam1ULLx
    unix-2.7.3 unordered-containers-0.2.20-Eo1ocpXri5ABLOF81VToPu
    vector-0.13.2.0-ByKMfTK8tTR39fPNQcIOcc
    vty-6.2-6J7TpqgblIG9Ul27jJ0fva

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

