#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-CgFtu5qQCHi3bSjs8xD9pq
key:                  gitit-0.15.1.2-CgFtu5qQCHi3bSjs8xD9pq
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  14b698a7104124cfb89aaeda1ff0a9bd
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-CgFtu5qQCHi3bSjs8xD9pq
depends:
    HStringTemplate-0.8.8-GsFNBm9YXiTH8EkYfqSblT
    HTTP-4000.4.1-LoME4GKPwD7IGA4wIHJt57
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-nTcMAwSjFOFbKrX5mWkol base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    blaze-html-0.9.2.0-7ZP6TBGCXvM5msBno7uCel bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-C1H0YOYecahE9pVRRJPliS
    feed-1.3.2.1-EoiJVee4Qe71XzRcbQP18r filepath-1.4.2.2
    filestore-0.6.5.1-7PIX2UOOjDdF3pXXy4J6Fj ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-e65T55q1tOD7F3TbSF1T9
    hoauth2-2.13.0-IXDUgqlczUj6b3hCiyPp0W
    hslogger-1.3.2.0-GJBVrqAdHKlSIVEViMWIa
    http-client-tls-0.3.6.4-CEK6krdvlVv4rw49kLfgyN
    http-conduit-2.3.9.1-IIq1tJb8o1N48P57D3hnXD
    json-0.10-E5T4WT5iwViBQk3qCcvqdq mtl-2.2.2
    network-3.1.4.0-9SQkdFTpEbMLQxc4pkijnN
    network-bsd-2.8.1.0-I8jHBOcjGYSHlQAfXD52Gs
    network-uri-2.6.4.2-IgEz3CB1YIOEy0roDjtsJm
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.3-BPHVMWfLpuMApCtc1PtgSV
    pandoc-types-1.23.1-FkFUARhdb9OCnDDWVCqBUK parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-EWI627yJJMEDZyiJYbiRy4
    recaptcha-0.1.0.4-LKVTakpV7MKKxA8a1o5zGy
    safe-0.3.21-JtmveFmtp7AKwHntYKRiun
    skylighting-0.14.2-Fr6k3FKaGeC8uEgWZqvnrd
    split-0.2.5-Jw4n4gsdaZK4FHILOCxPWx syb-0.7.3-CiEyKdVdKrBBmPO81uKiz6
    tagsoup-0.14.8-4k2JXJ2HSeJBamEkfypEYK
    temporary-1.3-C918ulOBEkN7TRyvGivete text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-8vS3C3xn8eH3sA38K91zFR
    url-2.1.3-E94S1FIs06M6qygH7sgKIA
    utf8-string-1.0.2-JqS4SAQdze6LQzXf6ug2xB
    uuid-1.3.16-2rR9aAgMEegIflyqT9HRxh xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-DJeejI7Bi9y3dPR04XiDH9
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-Curj2VlIrsl62gVRwBGLLT
    zlib-0.7.0.0-HZpZHQDuBUK2q5bSmtjxXS

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

