#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-Essv4arehF5A81FNJ6XmEt
key:                  gitit-0.15.1.2-Essv4arehF5A81FNJ6XmEt
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  908efc0adfd5409efdd6447e4f06217a
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-Essv4arehF5A81FNJ6XmEt
depends:
    HStringTemplate-0.8.8-AI9hJyWb9C8GQrXpDMgQh
    HTTP-4000.4.1-A4NZ39ytjSeCQl1hnehYzf
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-IUt8ms8F4mK1p5ihNOaPfT base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    blaze-html-0.9.2.0-Irz9BEYJh8t6ttuT8sjDNM bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-1xz0J7JcmZsK02WbpiceS
    feed-1.3.2.1-DVBgAdWRSaKFvOTeFFgyh4 filepath-1.4.2.2
    filestore-0.6.5.1-Khxuf9I4Qu819PqrCl0zK7 ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-AWqQsKnqvBuEE3VepbIVri
    hoauth2-2.13.0-KaeUjfWpH3Z1prZf694ZSY
    hslogger-1.3.2.0-1y0ReMtxTr7I5jlR5Eg9JE
    http-client-tls-0.3.6.4-2BNg0hEnHSJ5Bo7fM7Xyve
    http-conduit-2.3.9.1-BiJe1XkI0y2KbIzKrVWbPm
    json-0.10-kNrZNrsX7AAbyufe5WKXz mtl-2.2.2
    network-3.1.4.0-3FUQiZBqCiD6JAPkelGiT0
    network-bsd-2.8.1.0-5e1rpDVqhuI8pU4eOzJPiU
    network-uri-2.6.4.2-FdqTTZWnFNX96ukBHXQ0ED
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2.1-6hjiMIWeNwI2J6HFFwG9nz
    pandoc-types-1.23.1-JjlVk8mHzRf1JYJLiI61nl parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-8qBO4jKvrkh2o7oxGJ8dv
    recaptcha-0.1.0.4-5yGX5KBCmFlKd4OS9opwzC
    safe-0.3.21-JSgKJ1qQ11UGSifs2bSHTA
    skylighting-0.14.2-GuGUujLYr8dGQyc1qkofBO
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-7hkxsEejTxP3yJx3PgFbmA
    tagsoup-0.14.8-3PaODuvzH5i2WfKMjBWtOp
    temporary-1.3-sx8gB5yETjAWMh3lNT3tk text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-2lpcpNkDDcB5x4835uImCb
    url-2.1.3-88KgQieWhx3j6lduDBcZw
    utf8-string-1.0.2-6nfZpgw1Ffy3MDnMPT0XX9
    uuid-1.3.16-CCVcaow8w0JlmCECzu7oG xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-rF04dLWXau3PP9oaUTpHI
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-BHyhYiRfn3hElfUAk6qD7w
    zlib-0.7.0.0-9T3R7n3NMemFlfL7uoas2H

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

