#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-JA0frj4HZKzC5nwswMYqqI
key:                  gitit-0.15.1.2-JA0frj4HZKzC5nwswMYqqI
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  72bdb86a233bac0e0647b81d1928cc71
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-JA0frj4HZKzC5nwswMYqqI
depends:
    HStringTemplate-0.8.8-IXHdmVPf4BmFuWAwCShhlA
    HTTP-4000.4.1-LAknsGHYwqqLLOLJ1JbSy9
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-4RB85zdNr5p3whZ1np3a31 base-4.17.2.1
    base64-bytestring-1.2.1.0-ILHMKKXOF5jJ5iWlSCcrHn
    blaze-html-0.9.2.0-Cv5u1eWpWkgLQ3EG0vDZlF bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-5YERa1gRivJ1FQAeJ25kQD
    feed-1.3.2.1-GOiDrgi4ZKkHd3f5UMKWCU filepath-1.4.2.2
    filestore-0.6.5.1-FYAIeyoH22dF5FT1kRIIbk ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.2-FJh7gE2AIbL3Es38AHhQDC
    hoauth2-2.12.0-FpBs0ZI5xiJ8wDIp1Yh0B4
    hslogger-1.3.2.0-Du0tb6v80iuJuRgTUYirqH
    http-client-tls-0.3.6.4-Dbe6FDWu6Oe4BzTQkETXSS
    http-conduit-2.3.9.1-4gxxgZUedcOIrtFfJ1nJK0
    json-0.10-HXQ8mUR220A2DOWEcsUIln mtl-2.2.2
    network-3.1.4.0-KCu1LDB4kGQHeeCsiSLoOZ
    network-bsd-2.8.1.0-EQn85K5aNj6GARKlD20Ibk
    network-uri-2.6.4.2-yi3MP3fDM2AtnMkY6gtjY
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-4WNKGa2kY5VAnvJUlRfeE9
    pandoc-types-1.23.1-CLDITckbd5IHUKBBSAuTOr parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-H7b6I1swtfqDNx62GlcOH8
    recaptcha-0.1.0.4-CJmPrXeErEjIyYZ0ovzYyq
    safe-0.3.21-DKOKWo9pals8WHvcv2YlI8
    skylighting-0.14.2-198vuxp35uB480u4VnmIbx
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-8mb1dpoCL4AAb4S0Fpw3xy
    tagsoup-0.14.8-AQScOl7JAQZCQSVI62rKhC
    temporary-1.3-DvBGl4XgxXUEV6N6poxsKk text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-1x3nlaPId558Gv7xd9WiSc
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-EhXidLed9gM6Z7XoSBy8d6 xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-L3t63sJZHUiEjqyJCFyE7u
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-JgORxG2bttjGeJYPnbor6D
    zlib-0.7.0.0-CeIfwSJ4sxN7HYUOQk7SUo

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

