#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-AuR91v2Lgwp4oeJeSVb8Ay
key:                  gitit-0.15.1.2-AuR91v2Lgwp4oeJeSVb8Ay
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  ff33b46ee2c8b659db3f1f371f4e2564
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-AuR91v2Lgwp4oeJeSVb8Ay
depends:
    HStringTemplate-0.8.8-ACMggx62JDCD9tP9Z4Tsde
    HTTP-4000.4.1-KlTFh6TujbEIPw4bAnsJP1
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-6q2KNYwRaL29rPm6MMaiUC base-4.17.2.1
    base64-bytestring-1.2.1.0-ITj2xakY1ml2q5A6QmvnkU
    blaze-html-0.9.2.0-Dqz1hSF3Pl41AMAbxwq4Fa bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-J3iSnqB18M67Rw02zYe7xN
    feed-1.3.2.1-BqMIFj4Z3OL19FQr9sPoOO filepath-1.4.2.2
    filestore-0.6.5.1-4X84SPuvD2KFgoZQJLzUPf ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-Im3VF7iw7AJ1KaSX6H4NtX
    hoauth2-2.10.0-JENwnHecZskG8V883rX7yF
    hslogger-1.3.1.2-KdjG8VCujQjB54q4eJMKwb
    http-client-tls-0.3.6.4-JPbMvFYYazPC4HKKOIQQxM
    http-conduit-2.3.9.1-FnzYP5U7g9FDzbDtt4ESz8
    json-0.10-FbHNO2kSksW6M73hxOT5Rq mtl-2.2.2
    network-3.1.4.0-1Bok7DDOmdQ7OlyZLPDJ7H
    network-bsd-2.8.1.0-3vouKFKPuJxRPZurkP2cG
    network-uri-2.6.4.2-4guMK9PpDjI4XiQikAf4nE
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.1.13-8rrp7861fcpEcbEDH7cvWc
    pandoc-types-1.23.1-1lPkdEDfY3GFRObAHtYsQM parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-2cudg871s2f2tL4YjAU8WJ
    recaptcha-0.1.0.4-JzsGoOdbd3Q4S9utycXSlQ
    safe-0.3.21-85eF7qPff6wBGTusoDGORM
    skylighting-0.14.1.1-hyfGM9aBBYLt63GX2KZ79
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    syb-0.7.2.4-Au9jUQxtdeJGhFGXkWlbWz
    tagsoup-0.14.8-Io71Qzz0AUJ8mN7Soqan8G
    temporary-1.3-836zY2cPz8HAaBXH2WMEd1 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-GQI99P27AtfAb3NYljAgZJ
    url-2.1.3-5jqeZ5XJ7ppHdpwVy0F3TG
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    uuid-1.3.16-Lkoa9WUokygHxRiL5Bnkfi xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-8FhwcO2FTQSFazR5N5lT2S
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-4dHoXnNPIQpH6Vc3ulOWbp
    zlib-0.7.0.0-6t7E8pSANES5j7b97RkZZY

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

