#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-K347LRbn1jf2eQfEh2KteA
key:                  gitit-0.15.1.2-K347LRbn1jf2eQfEh2KteA
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  d614b8e19000e225b691b7ad0a6f095e
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-K347LRbn1jf2eQfEh2KteA
depends:
    HStringTemplate-0.8.8-9md8BQLURyCI4WkIRFDCI1
    HTTP-4000.4.1-KuyjCR7HUT5I1dJUpIuPzp
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-H1ahbkp4Y7o4mfa4dlXJ2M base-4.17.2.1
    base64-bytestring-1.2.1.0-Chm70B0PYm3wQkrmM5U2R
    blaze-html-0.9.2.0-9XbYd3BuaoOCWGJeBuMwxI bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-BaHVTIQIJzfLBnr771fGIq
    feed-1.3.2.1-CG4WTBFdNC78o1ejYl25LH filepath-1.4.2.2
    filestore-0.6.5.1-AyNCILZFYWe6cI6234WPTk ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-95NYB1oIPSRLHtVxMG0LfJ
    hoauth2-2.11.0-HNxYJNQtPNHBOpJ6oUEXXI
    hslogger-1.3.1.2-2MeceiWK6arII2bas4yy5w
    http-client-tls-0.3.6.4-ADgMftrIfn84MlVUzQaPAi
    http-conduit-2.3.9.1-6ypk441yhg5EqCm31F4Jer
    json-0.10-FDPGsXzpLW1HTCsmwVxFpW mtl-2.2.2
    network-3.1.4.0-Ds1jGwhI6OBB7cQ3449UkE
    network-bsd-2.8.1.0-6nsbeEThd6fHNJgOMQQbYU
    network-uri-2.6.4.2-BUyFg1hFmM35dSD0y76h3W
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-IlDwlEM4fjzKti03AFLAg0
    pandoc-types-1.23.1-4tDmxey01LQE0fjoYxBlH7 parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-6y99CLYUqOs4N5Dmmd11Ha
    recaptcha-0.1.0.4-BMeWD8gSiq8LEhF2Yay4ty
    safe-0.3.21-Jsj2ePpKDeG8OpB2hRbMdb
    skylighting-0.14.1.2-Hnr1FK68xag1MKeCLa0p4p
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    syb-0.7.2.4-3MUyG3p3euQLeyQ65NE0AP
    tagsoup-0.14.8-CtyVacAJgReIOOSvBg6ERr
    temporary-1.3-AgnyQJqoH2tBVE9T1YksW9 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-BPzB27xU1Ar2KMXTIIsLlJ
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-DanzINKvYx15Ks0b7zIKaS xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-5jKbrHK1wKfGwYIQbOE7GC
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-HqwnfdhcvS07PlOUlnkqfW
    zlib-0.7.0.0-30oOQFSD0dHCSPuXH9d3q6

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

