#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-9tAD3mZmMgB5D7Xb0fF8kp
key:                  gitit-0.15.1.2-9tAD3mZmMgB5D7Xb0fF8kp
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  aedf402a3a197e546e3ba10a824e4ed7
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-9tAD3mZmMgB5D7Xb0fF8kp
depends:
    HStringTemplate-0.8.8-Izo6x4FcG6tJ7uWGnFWIhI
    HTTP-4000.4.1-K9z9SDe9mMBASKCmqGLgM1
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-BWqAP5DPS0iMNSAJtMWSf base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb
    blaze-html-0.9.2.0-E5DRDiEbjc2BhlgdqWwu1Z bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-2qWt5TFjbNR6N0bJ1Vcp2e
    feed-1.3.2.1-ALBsi7Ork86GWO647YWmhd filepath-1.4.2.2
    filestore-0.6.5.1-3M49NsVXYVV7Hiiohosfy ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-FpVY310GSmH6Z6j1Q9RrQn
    hoauth2-2.10.0-Bg7raaDhLYWIcsfqLDlnLN
    hslogger-1.3.1.2-GIVQK8pFi7x2E6AFeOydBR
    http-client-tls-0.3.6.4-1iaAAi64BfdGALlJ7qoOys
    http-conduit-2.3.9.1-KYb3AREOVb2COrnBIWmjoV
    json-0.10-DQPn2NYxP066Js3S5opnk0 mtl-2.2.2
    network-3.1.4.0-Be19ySMD4vC3IuDyb1IMcQ
    network-bsd-2.8.1.0-8nF6OiDi4TCFyEvm0nFicP
    network-uri-2.6.4.2-CScpRPfTOboAxTStoroPUs
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-Hu3WWVEm8SWLdJzGAYtl23
    pandoc-types-1.23.1-4bCfz5uHFDBG0F6FLR9gJY parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-ddmLWvz8i69p1T3sgcHVE
    recaptcha-0.1.0.4-HH7M1z3iof7HhhPtdFevHf
    safe-0.3.21-6ICTSoJojhWH0zx8fOEOEW
    skylighting-0.14.1.2-IrEjOmquxFEPgZCmSnOss
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    syb-0.7.2.4-BSKNIdKaKEZCAuXcVMqAaV
    tagsoup-0.14.8-EUwY4nLfxKtEZ8xZ50zyTr
    temporary-1.3-JIXZ1S2ItU295qbRBPUO0q text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-9p52xpVpUdTDBZfT4PrfQe
    url-2.1.3-5jqeZ5XJ7ppHdpwVy0F3TG
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    uuid-1.3.16-J4gB01iNqQp6MMhQljSOrZ xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-5NlIlEigghS9R599y2GwmC
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-2GZyLYqP0egVRgbHdZwQs
    zlib-0.7.0.0-JTYJvh7bdef7shhdY83ka1

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

