/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.HSLColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColorValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import java.util.Objects;
import org.w3c.dom.DOMException;

class RGBColor
extends BaseColor
implements RGBAColor {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue red = null;
    private PrimitiveValue green = null;
    private PrimitiveValue blue = null;

    RGBColor() {
    }

    RGBColor(RGBColor rGBColor) {
        this.red = rGBColor.red.clone();
        this.green = rGBColor.green.clone();
        this.blue = rGBColor.blue.clone();
        this.setAlpha(rGBColor.alpha.clone());
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.RGB;
    }

    @Override
    void set(BaseColor baseColor) {
        super.set(baseColor);
        RGBColor rGBColor = (RGBColor)baseColor;
        this.red = rGBColor.red;
        this.green = rGBColor.green;
        this.blue = rGBColor.blue;
    }

    @Override
    public PrimitiveValue item(int n) {
        switch (n) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getRed();
            }
            case 2: {
                return this.getGreen();
            }
            case 3: {
                return this.getBlue();
            }
        }
        return null;
    }

    @Override
    void setComponent(int n, PrimitiveValue primitiveValue) {
        switch (n) {
            case 0: {
                this.setAlpha(primitiveValue);
                break;
            }
            case 1: {
                this.setRed(primitiveValue);
                break;
            }
            case 2: {
                this.setGreen(primitiveValue);
                break;
            }
            case 3: {
                this.setBlue(primitiveValue);
            }
        }
    }

    public void setRed(PrimitiveValue primitiveValue) throws DOMException {
        if (primitiveValue == null) {
            throw new NullPointerException();
        }
        this.red = this.enforceColorComponentType(primitiveValue);
    }

    PrimitiveValue enforceColorComponentType(PrimitiveValue primitiveValue) throws DOMException {
        Object object;
        if (primitiveValue.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            object = new PercentageEvaluator();
            primitiveValue = (PrimitiveValue)((Object)((PercentageEvaluator)object).evaluateExpression((CSSExpressionValue)((Object)primitiveValue)));
        } else if (primitiveValue.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            object = new PercentageEvaluator();
            primitiveValue = (PrimitiveValue)((Object)((PercentageEvaluator)object).evaluateFunction((CSSMathFunctionValue)((Object)primitiveValue)));
        }
        if (primitiveValue.getUnitType() == 0) {
            object = (CSSTypedValue)((Object)primitiveValue);
            float f = object.getFloatValue((short)0);
            if (f < 0.0f) {
                if (!object.isCalculatedNumber()) {
                    throw new DOMException(15, "Color component cannot be smaller than zero.");
                }
                object.setFloatValue((short)0, 0.0f);
            }
        } else if (primitiveValue.getUnitType() == 2) {
            object = (CSSTypedValue)((Object)primitiveValue);
            float f = object.getFloatValue((short)2);
            if (f < 0.0f || f > 100.0f) {
                if (!object.isCalculatedNumber()) {
                    throw new DOMException(15, "Color component percentage cannot be smaller than zero or greater than 100%.");
                }
                if (f < 0.0f) {
                    object.setFloatValue((short)2, 0.0f);
                } else {
                    object.setFloatValue((short)2, 100.0f);
                }
            }
        } else if (!(primitiveValue.getCssValueType() == CSSValue.CssType.PROXY || primitiveValue.getPrimitiveType() == CSSValue.Type.EXPRESSION || primitiveValue.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION || primitiveValue.getPrimitiveType() == CSSValue.Type.FUNCTION || primitiveValue.getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((TypedValue)primitiveValue).getStringValue()))) {
            throw new DOMException(17, "Type not compatible with color component.");
        }
        return primitiveValue;
    }

    @Override
    public PrimitiveValue getRed() {
        return this.red;
    }

    public void setGreen(PrimitiveValue primitiveValue) throws DOMException {
        if (primitiveValue == null) {
            throw new NullPointerException();
        }
        this.green = this.enforceColorComponentType(primitiveValue);
    }

    @Override
    public PrimitiveValue getGreen() {
        return this.green;
    }

    public void setBlue(PrimitiveValue primitiveValue) throws DOMException {
        if (primitiveValue == null) {
            throw new NullPointerException();
        }
        this.blue = this.enforceColorComponentType(primitiveValue);
    }

    @Override
    public PrimitiveValue getBlue() {
        return this.blue;
    }

    @Override
    boolean hasConvertibleComponents() {
        return RGBColor.isConvertibleComponent(this.getRed()) && RGBColor.isConvertibleComponent(this.getGreen()) && RGBColor.isConvertibleComponent(this.getBlue());
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] dArray = new double[]{this.rgbComponentNormalized((TypedValue)this.getRed()), this.rgbComponentNormalized((TypedValue)this.getGreen()), this.rgbComponentNormalized((TypedValue)this.getBlue())};
        return dArray;
    }

    @Override
    void setColorComponents(double[] dArray) {
        PercentageValue percentageValue = new PercentageValue();
        percentageValue.setFloatValue((short)2, (float)(dArray[0] * 100.0));
        percentageValue.setSubproperty(true);
        percentageValue.setAbsolutizedUnit();
        this.setRed(percentageValue);
        PercentageValue percentageValue2 = new PercentageValue();
        percentageValue2.setFloatValue((short)2, (float)(dArray[1] * 100.0));
        percentageValue2.setSubproperty(true);
        percentageValue2.setAbsolutizedUnit();
        this.setGreen(percentageValue2);
        PercentageValue percentageValue3 = new PercentageValue();
        percentageValue3.setFloatValue((short)2, (float)(dArray[2] * 100.0));
        percentageValue3.setSubproperty(true);
        percentageValue3.setAbsolutizedUnit();
        this.setBlue(percentageValue3);
    }

    @Override
    double[] toSRGB(boolean bl) throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] dArray = new double[]{this.rgbComponentNormalized((TypedValue)this.getRed()), this.rgbComponentNormalized((TypedValue)this.getGreen()), this.rgbComponentNormalized((TypedValue)this.getBlue())};
        return dArray;
    }

    @Override
    public double[] toXYZ(Illuminant illuminant) {
        double[] dArray = this.toSRGB(true);
        double d = RGBColor.inverseSRGBCompanding(dArray[0]);
        double d2 = RGBColor.inverseSRGBCompanding(dArray[1]);
        double d3 = RGBColor.inverseSRGBCompanding(dArray[2]);
        double[] dArray2 = ColorUtil.linearSRGBToXYZd65(d, d2, d3);
        if (illuminant == Illuminant.D50) {
            dArray2 = ColorUtil.d65xyzToD50(dArray2);
        }
        return dArray2;
    }

    public HSLColor toHSLColor() {
        HSLColorImpl hSLColorImpl = this.createHSLColor();
        this.toHSLColor(hSLColorImpl);
        return hSLColorImpl;
    }

    HSLColorImpl createHSLColor() {
        return new HSLColorImpl();
    }

    void toHSLColor(HSLColorImpl hSLColorImpl) throws DOMException {
        double[] dArray = this.toHSL();
        if (dArray == null) {
            throw new DOMException(11, "Conversion to hsl() failed.");
        }
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)80, (float)dArray[0]);
        numberValue.setAbsolutizedUnit();
        PercentageValue percentageValue = new PercentageValue();
        percentageValue.setFloatValue((short)2, (float)dArray[1]);
        percentageValue.setAbsolutizedUnit();
        PercentageValue percentageValue2 = new PercentageValue();
        percentageValue2.setFloatValue((short)2, (float)dArray[2]);
        percentageValue2.setAbsolutizedUnit();
        hSLColorImpl.setHue(numberValue);
        hSLColorImpl.setSaturation(percentageValue);
        hSLColorImpl.setLightness(percentageValue2);
        hSLColorImpl.setAlpha(this.getAlpha());
    }

    double[] toHSL() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double d = this.rgbComponentNormalized((TypedValue)this.red);
        double d2 = this.rgbComponentNormalized((TypedValue)this.green);
        double d3 = this.rgbComponentNormalized((TypedValue)this.blue);
        if (d > 1.0 || d2 > 1.0 || d3 > 1.0) {
            return null;
        }
        return ColorUtil.srgbToHsl(d, d2, d3);
    }

    double rgbComponentNormalized(TypedValue typedValue) throws DOMException {
        double d;
        short s = typedValue.getUnitType();
        if (s == 2) {
            d = (double)typedValue.getFloatValue((short)2) * 0.01;
        } else if (s == 0) {
            d = (double)typedValue.getFloatValue((short)0) / 255.0;
        } else if (typedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            d = 0.0;
        } else {
            throw new DOMException(17, "Wrong component: " + typedValue.getCssText());
        }
        return d;
    }

    static double inverseSRGBCompanding(double d) {
        double d2 = Math.abs(d);
        double d3 = d2 <= 0.04045 ? d / 12.92 : Math.signum(d) * Math.pow((d2 + 0.055) / 1.055, 2.4);
        return d3;
    }

    @Override
    public String toString() {
        return this.oldFunctionalString(this.isNonOpaque());
    }

    String oldFunctionalString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(25);
        if (bl) {
            stringBuilder.append("rgba(");
        } else {
            stringBuilder.append("rgb(");
        }
        this.appendComponentCssText(stringBuilder, this.getRed()).append(", ");
        this.appendComponentCssText(stringBuilder, this.getGreen()).append(", ");
        this.appendComponentCssText(stringBuilder, this.getBlue());
        if (bl) {
            stringBuilder.append(", ");
            this.appendAlphaChannel(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toMinifiedString() {
        return this.minifiedOldFunctionalString(this.isNonOpaque());
    }

    String minifiedOldFunctionalString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(24);
        if (bl) {
            stringBuilder.append("rgba(");
        } else {
            stringBuilder.append("rgb(");
        }
        this.appendComponentMinifiedCssText(stringBuilder, this.getRed()).append(',');
        this.appendComponentMinifiedCssText(stringBuilder, this.getGreen()).append(',');
        this.appendComponentMinifiedCssText(stringBuilder, this.getBlue());
        if (bl) {
            stringBuilder.append(',');
            this.appendAlphaChannelMinified(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.blue == null ? 0 : this.colorComponentHashCode(this.blue));
        n2 = 31 * n2 + (this.green == null ? 0 : this.colorComponentHashCode(this.green));
        n2 = 31 * n2 + (this.red == null ? 0 : this.colorComponentHashCode(this.red));
        n2 = 31 * n2 + this.alpha.hashCode();
        return n2 * 31;
    }

    private int colorComponentHashCode(PrimitiveValue primitiveValue) {
        if (primitiveValue.getPrimitiveType() != CSSValue.Type.NUMERIC) {
            return primitiveValue.hashCode();
        }
        TypedValue typedValue = (TypedValue)primitiveValue;
        float f = primitiveValue.getUnitType() == 2 ? typedValue.getFloatValue((short)2) * 2.55f : typedValue.getFloatValue((short)0);
        return Float.floatToIntBits(f);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof RGBColor)) {
            return false;
        }
        RGBColor rGBColor = (RGBColor)object;
        if (this.blue == null ? rGBColor.blue != null : !this.blue.equals(rGBColor.blue)) {
            return false;
        }
        if (this.green == null ? rGBColor.green != null : !this.green.equals(rGBColor.green)) {
            return false;
        }
        if (this.red == null ? rGBColor.red != null : !this.red.equals(rGBColor.red)) {
            return false;
        }
        return Objects.equals(this.alpha, rGBColor.alpha);
    }

    @Override
    public ColorValue packInValue() {
        return new RGBColorValue(this);
    }

    @Override
    public RGBColor clone() {
        return new RGBColor(this);
    }
}

