/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSRuleList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

class AbstractRuleList<T extends CSSRule>
extends ArrayList<T>
implements CSSRuleList<T> {
    private static final long serialVersionUID = 2L;

    public AbstractRuleList(int n) {
        super(n);
    }

    public AbstractRuleList() {
        super(16);
    }

    public AbstractRuleList(Collection<? extends T> collection) {
        super(collection);
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public T item(int n) {
        if (n >= this.getLength() || n < 0) {
            return null;
        }
        return (T)((CSSRule)this.get(n));
    }

    public boolean append(T t) {
        return super.add(t);
    }

    @Override
    public String toMinifiedString() {
        int n = this.size();
        StringBuilder stringBuilder = new StringBuilder(n * 20);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.item(i).getMinifiedCssText());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        int n = this.size();
        StringBuilder stringBuilder = new StringBuilder(n * 20);
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.css.CSSRule cSSRule = this.item(i);
            stringBuilder.append(cSSRule.getCssText()).append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.css.CSSRule cSSRule = this.item(i);
            cSSRule.writeCssText(simpleWriter, styleFormattingContext);
        }
    }
}

