/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.view.swing.map.attribute.AttributeTableModel;
import org.freeplane.view.swing.map.attribute.AttributeView;

class ExtendedAttributeTableModelDecorator
extends AttributeTableModel {
    private static final int AFTER_LAST_ROW = Integer.MAX_VALUE;
    private static final long serialVersionUID = 1L;
    int newRow;
    private final AttributeView attributeView;

    public ExtendedAttributeTableModelDecorator(AttributeView attrView) {
        super(attrView);
        this.attributeView = attrView;
        this.newRow = Integer.MAX_VALUE;
    }

    @Override
    public boolean areAttributesVisible() {
        return this.getRowCount() != 0 || !this.attributeView.isReduced();
    }

    @Override
    public void editingCanceled() {
        if (this.newRow != Integer.MAX_VALUE) {
            int row = this.newRow;
            this.newRow = Integer.MAX_VALUE;
            this.fireTableRowsDeleted(row, row);
        }
    }

    @Override
    public int getRowCount() {
        if (this.newRow == Integer.MAX_VALUE) {
            return this.getNodeAttributeModel().getRowCount();
        }
        return this.getNodeAttributeModel().getRowCount() + 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        NodeAttributeTableModel attributes = this.getNodeAttributeModel();
        if (row == this.newRow || row >= attributes.getRowCount()) {
            return "";
        }
        if (row < this.newRow) {
            return attributes.getValueAt(row, col);
        }
        return attributes.getValueAt(row - 1, col);
    }

    public void insertRow(int index) {
        this.newRow = index;
        this.fireTableRowsInserted(index, index);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row != this.newRow) {
            return this.getAttributeController().canEdit() && !this.getAttribute(row).isManaged();
        }
        return col == 0;
    }

    public void moveRowDown(int row) {
        Attribute attribute = this.getAttributeController().performRemoveRow(this.getNode(), this.getNodeAttributeModel(), row);
        this.getAttributeController().performInsertRow(this.getNode(), this.getNodeAttributeModel(), row + 1, attribute.getName(), attribute.getValue());
    }

    public void moveRowUp(int row) {
        Attribute attribute = this.getAttributeController().performRemoveRow(this.getNode(), this.getNodeAttributeModel(), row);
        this.getAttributeController().performInsertRow(this.getNode(), this.getNodeAttributeModel(), row - 1, attribute.getName(), attribute.getValue());
    }

    public Object removeRow(int index) {
        return this.getAttributeController().performRemoveRow(this.getNode(), this.getNodeAttributeModel(), index);
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        if (row != this.newRow) {
            if (col == 1 || o.toString().length() > 0) {
                int rowInModel = row < this.newRow ? row : row - 1;
                this.getAttributeController().performSetValueAt(this.getNode(), this.getNodeAttributeModel(), o, rowInModel, col);
            }
            return;
        }
        this.newRow = Integer.MAX_VALUE;
        this.fireTableRowsDeleted(row, row);
        if (col == 0 && o != null && o.toString().length() > 0) {
            this.getAttributeController().performInsertRow(this.getNode(), this.getNodeAttributeModel(), row, o.toString(), "");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireTableDataChanged();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        this.fireTableChanged(new TableModelEvent(this, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType()));
    }

    @Override
    public Attribute getAttribute(int row) {
        if (row < this.newRow) {
            return this.getNodeAttributeModel().getAttribute(row);
        }
        if (row == this.newRow) {
            return null;
        }
        return this.getNodeAttributeModel().getAttribute(row);
    }

    @Override
    public int targetRow(int row) {
        return row;
    }
}

