/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Path2D;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.link.CollisionDetector;

public class LinearEdgeView
extends EdgeView {
    public LinearEdgeView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    @Override
    protected void draw(Graphics2D g) {
        int w = this.getWidth();
        if (w <= 1) {
            g.drawLine(this.start.x, this.start.y, this.shapeStart.x, this.shapeStart.y);
            g.drawLine(this.shapeStart.x, this.shapeStart.y, this.end.x, this.end.y);
            if (this.drawHiddenParentEdge()) {
                g.setColor(g.getBackground());
                g.setStroke(EdgeView.getEclipsedStroke());
                g.drawLine(this.start.x, this.start.y, this.shapeStart.x, this.shapeStart.y);
                g.drawLine(this.shapeStart.x, this.shapeStart.y, this.end.x, this.end.y);
            }
        } else {
            Point startControlPoint = this.getControlPoint(this.getStartConnectorLocation());
            int zoomedXCTRL = w + 1;
            int xctrl = startControlPoint.x * zoomedXCTRL;
            int yctrl = startControlPoint.y * zoomedXCTRL;
            Point endControlPoint = this.getControlPoint(this.getEndConnectorLocation());
            int childXctrl = endControlPoint.x * zoomedXCTRL;
            int childYctrl = endControlPoint.y * zoomedXCTRL;
            int[] xs = new int[]{this.start.x, this.shapeStart.x, this.shapeStart.x + xctrl, this.end.x + childXctrl, this.end.x};
            int[] ys = new int[]{this.start.y, this.shapeStart.y, this.shapeStart.y + yctrl, this.end.y + childYctrl, this.end.y};
            g.drawPolyline(xs, ys, 4);
            if (this.drawHiddenParentEdge()) {
                g.setColor(g.getBackground());
                g.setStroke(EdgeView.getEclipsedStroke());
                g.drawPolyline(xs, ys, 4);
            }
        }
    }

    @Override
    public boolean detectCollision(Point p) {
        Path2D.Float line = new Path2D.Float();
        ((Path2D)line).moveTo(this.start.x, this.start.y);
        if (this.start != this.shapeStart) {
            ((Path2D)line).lineTo(this.shapeStart.x, this.shapeStart.y);
        }
        ((Path2D)line).lineTo(this.end.x, this.end.y);
        return new CollisionDetector().detectCollision(p, line);
    }
}

