#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-JqCsTzVJDct5fv0CGIQMNM
key:                  dhall-1.42.3-JqCsTzVJDct5fv0CGIQMNM
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  e9fa0d5b31056b55e41ec88903a15c73
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-JqCsTzVJDct5fv0CGIQMNM
depends:
    Diff-0.5-DfgrTjzmKsXIKxa4pCXDt2
    aeson-2.1.2.1-4RB85zdNr5p3whZ1np3a31
    aeson-pretty-0.8.10-BxZb0Y9uJoDLFOdQikw8UU
    ansi-terminal-1.0.2-4v7foyTOWos7vsV6BCUMgI
    atomic-write-0.2.1.1-HqhNyMmhzUnJzZH2p91Z7O base-4.17.2.1
    base16-bytestring-1.0.2.0-2HZcxZQrp2G92HohcNwteN
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-LYFsGNYxHzcJNUKypl8Xr7
    cborg-0.2.10.0-BmOwtuheRsj52LFSR43Vzk
    cborg-json-0.2.6.0-GSw3zZPUh8aJVZBYFzJaWc containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-Q4n8YDkmZZBVf5UDNpOvm
    data-fix-0.3.4-CBrzdR2JmQ7F35VN8QKSUS deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-Ofj8z9dcLGLwajoO9mRz5 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-JJ2w8qI4XWy3XqNJeDbhZE
    hashable-1.4.5.0-EMf4Iv4OllUGRj72K4SCf0 haskeline-0.8.2
    http-client-0.7.19-BlnOOoYFAm21qMqpEBWgqP
    http-client-tls-0.3.6.4-Dbe6FDWu6Oe4BzTQkETXSS
    http-types-0.12.4-Jx04LytKDQxAS6dwQTH9Cw
    indexed-traversable-0.1.4-HEP7TGiK1hWFsWJfrW3hPw
    megaparsec-9.7.0-820EiikhmYYJfbjX1fu2Y5
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-yi3MP3fDM2AtnMkY6gtjY
    optparse-applicative-0.18.1.0-LLjVXIIvCj2EgCMfmpm2Bg
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-KExJse5L7Lp2PoqRl67KBV
    pretty-simple-4.1.3.0-LFfxPpTQAxZHW5nthv775Z
    prettyprinter-1.7.1-Akkp0WpHSIjZLnKQ6G5af
    prettyprinter-ansi-terminal-1.1.3-CospziYmNkwAY8CNK8Zl1h
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-75VbuY3tmfA8QFAgCCeEHk
    serialise-0.2.6.1-CPELzbK4DBa3JIlfNSXSJY template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-HVRskRns4uX3mgTH6QsfUD
    text-short-0.1.6-9KnxmTZOVev4vYpYI5BOBx
    th-lift-instances-0.1.20-HgeHp6Lk918HJIeDuzr9BU time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-AZ3QvicZDsfFka2eKBF0EH
    unordered-containers-0.2.20-L410VxfvorQ5RMb8wocThG
    vector-0.13.2.0-B3Rnif6nhJNLHPAZlzHp2g

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

