#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-4tb3zdSZuw1HTyRLUYCgdI
key:                  dhall-1.42.3-4tb3zdSZuw1HTyRLUYCgdI
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  29fbf7fbb90457bf29902c60447ac370
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-4tb3zdSZuw1HTyRLUYCgdI
depends:
    Diff-0.5-8Hys7qBFsDx3PrDtGKpYZN
    aeson-2.1.2.1-30WJrKK1Pbc1pP0H7Lz8HG
    aeson-pretty-0.8.10-AjomkTZ0a67SD24rhcExB
    ansi-terminal-1.0.2-3mjPvI8uzrIHyOcajwCdFZ
    atomic-write-0.2.1.1-7H212Yt6438JD9273IbegS base-4.17.2.1
    base16-bytestring-1.0.2.0-DUqHedAHAQbJjSb7t2C2Fa
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-3u1lhibUOI39diOsp8dwhN
    cborg-0.2.10.0-5Ytcprca5hlFfJLL0gFKZp
    cborg-json-0.2.6.0-4bEeCjJfG84K2IUif5aqOk containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-BWTyLupTQn7EO7jgqEkNXd
    data-fix-0.3.4-HNyWd7GOMT1FiTSl1XF8N9 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-rHAnuiMvw5AWNhhfsw0ES exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-FtKtf5RyC1lHy6J24ZUuEW
    hashable-1.4.5.0-JHGJZlFhSc53NK2NYV614f haskeline-0.8.2
    http-client-0.7.19-E75obOxKY6lFjozf9B0Cdj
    http-client-tls-0.3.6.4-JnWaCoPi7KZ8DaHdfoFfuf
    http-types-0.12.4-HAGemqHxPpJ61NPMOsJY37
    indexed-traversable-0.1.4-1JQoS0W1FKXHtvIno5fsGs
    megaparsec-9.7.0-3uOOds7dkmdKa9eAfy4ha7
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-4dyZiFqUsAXDJ8mS3jtc8B
    optparse-applicative-0.18.1.0-K3CbF5FSqXbBKh39LN9JOE
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-JZdRcBOfwQO9wezFHjpH5F
    pretty-simple-4.1.3.0-4l5r6XQrt1jEpRwg6iuMgQ
    prettyprinter-1.7.1-GISel4GwMefHj3FidpnW09
    prettyprinter-ansi-terminal-1.1.3-8UOwX8rKTlo26LHvvVWgFr
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-Ksazu1q4lbv7nBtRDhz1zC
    serialise-0.2.6.1-3i7t5IFMEQHoFFR3MLyC9 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-E3fBiSvEQxr8BrFMjMChn4
    text-short-0.1.6-FjJkVdy1264H7kEs2hJTG7
    th-lift-instances-0.1.20-31trta2BncpCoM5Fq2mFo4 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-GRcWteAUk7yFBTumPQtTNN
    unordered-containers-0.2.20-JDDg5JU7nYP5ffg7vR2UZh
    vector-0.13.2.0-LerqRcvS8LMBGXOi8GqDsa

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

