#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-Gj8N3pW1tKrIafOUJKXFc3
key:                  dhall-1.42.3-Gj8N3pW1tKrIafOUJKXFc3
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  18610b9a9a9293049798619301a201bf
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-Gj8N3pW1tKrIafOUJKXFc3
depends:
    Diff-0.5-HZiJH1oQgrHCiSmIfGIBYM
    aeson-2.1.2.1-6h5MFvBT17H5yplsTy4ABm
    aeson-pretty-0.8.10-BWBr3n5fp9E4XyIlTfMbVH
    ansi-terminal-1.0.2-LCUEwZc5qNZJRy74Vr4a1h
    atomic-write-0.2.1.1-F1y9kZ9C32y8ybV8D8JKxi base-4.17.2.1
    base16-bytestring-1.0.2.0-FCpQxPpZ6OtJjyjiCnnSOC
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-rTys5srD4l50KQCiQKWYt
    cborg-0.2.10.0-2ud90f33r94HyEUWpHNqxa
    cborg-json-0.2.6.0-2wDN8DLHEV1JbJSm4S5uwT containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-9pIZgwpD2w9CKxv3QLViI9
    data-fix-0.3.4-B5x4nzUdT315Y6CqZLVHI4 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-73MLXCQBVC87HSiWToTBdZ exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-I0bqkJr7rUM2mfAMc81Dp7
    hashable-1.4.7.0-GgneweRn8eTKcMM4X3n956 haskeline-0.8.2
    http-client-0.7.19-1818a0SJLwXE4QrSYiVT7V
    http-client-tls-0.3.6.4-26jJPqfpxqfJih66sxENJC
    http-types-0.12.4-8KsSLLTB3zVcsjL7f3kez
    indexed-traversable-0.1.4-7gBVHmZFzpQ83JoiKc0FfD
    megaparsec-9.7.0-FpJKK1G9cbN77HLJbKTZuE
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-60V3uLcyBv8HHhnYdb8knn
    optparse-applicative-0.18.1.0-Fys7kMiK5mr3sU6DxR5vVs
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-ihqet4fuoxFRlRUwFGy3H
    pretty-simple-4.1.3.0-46TcYzE4zzL8dQ7uhcBpCL
    prettyprinter-1.7.1-HSfe9r3toGeG5iYKvTbBEv
    prettyprinter-ansi-terminal-1.1.3-HBd0HlPB5W983yTXobQ0Tw
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-3KgWCwEWnxjIUGX8ssH1BR
    serialise-0.2.6.1-IiNhvJQDEaWA7JUfPOxHtt template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-RMvyNJvzRz144Q0MXDFFP
    text-short-0.1.6-GdsWmfC5DnDEgDZEzODvMK
    th-lift-instances-0.1.20-EljlVUl8i9r7BVvai02pvw time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-9iy3Mma5ULC2KPJCZc9N5C
    unordered-containers-0.2.20-2N1fR83O3bC5qS2nrjaL2B
    vector-0.13.2.0-EQFZws9ZIK8A2ESM3MR23n

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

