#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-Sed3THImkmF9lksTC729n
key:                  dhall-1.42.3-Sed3THImkmF9lksTC729n
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  c32cf25f8b0934b1a6d889f225aff345
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-Sed3THImkmF9lksTC729n
depends:
    Diff-0.5-BWrCyH5C3Bv4s0avY6wwOE
    aeson-2.1.2.1-7VTFzNaeQhH4xougawMBap
    aeson-pretty-0.8.10-rURyXjN4BvGGSaNmtsiAe
    ansi-terminal-1.0.2-JNQYc01xThWEgUAi55dqd4
    atomic-write-0.2.1.1-FQjdaH7Zh24vDuTvhTo7T base-4.17.2.1
    base16-bytestring-1.0.2.0-LR2y57Bi8RU55o0THQ9plt
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4P9iCjJMWMIHxNOvyaASZG
    cborg-0.2.10.0-HoTQioXVkvwBSRZ40X7TvC
    cborg-json-0.2.6.0-4InUI3J1dvJtlPlsE6Fg7 containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-AOT7qCoHBy69f6O1ayuJDv
    data-fix-0.3.4-7CDCOIhpvJAI6fy7F7AnJ6 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-7e09p0bwk1dC0sXKvTRSQ2 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-JPRDflLMac5p6YERd0GYl
    hashable-1.4.6.0-8MG0S5dfyXU6lRGLMgbs1l haskeline-0.8.2
    http-client-0.7.19-sF7xCO9vzdEEZgZxhmYN0
    http-client-tls-0.3.6.4-KuHBcB0W0Xm9oqpoqFuecp
    http-types-0.12.4-3DQiCH8RwXkLA2zexb7ibB
    indexed-traversable-0.1.4-1hTsLhK6E4tI5A8Ow8lBff
    megaparsec-9.7.0-EiOytuystFBC1v5RoiaLHB
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-3JXfaFN99ue5xMdSDFu2sO
    optparse-applicative-0.18.1.0-G3Jl5lNMtd03bbRRexh6Dm
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-LCstr1OOarbKBmGQCnwBvJ
    pretty-simple-4.1.3.0-IuchbPKvGM61rhkpenzowc
    prettyprinter-1.7.1-1bGrHmHQilYFdKnOhsKcRi
    prettyprinter-ansi-terminal-1.1.3-YFnQxSjmLFCvcICXGVVkT
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-5k7RkjOpOBv4OfSmUBfqB5
    serialise-0.2.6.1-3Tf4eprYiV1Cc88mGJH0qS template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-6sFXrGHwXv81fs5CaeHGyr
    text-short-0.1.6-667XBtk7wjZ44SMyYYC3F0
    th-lift-instances-0.1.20-Ad7qZVpF2QcAKihKP7n753 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-9zHJnmH6dkzJQafueuILIm
    unordered-containers-0.2.20-Iia3zhz8DVL3Efh3E6ja96
    vector-0.13.2.0-89nHvRrlFmk5zBBEvFgHzR

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

