#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-1vcQdfkiB2GKDBFckIkY7G
key:                  dhall-1.42.3-1vcQdfkiB2GKDBFckIkY7G
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  cbe41e490f94c42c2ace6b1be0f41916
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-1vcQdfkiB2GKDBFckIkY7G
depends:
    Diff-0.5-5Q1Xtyajup54pAeJMO94Af
    aeson-2.1.2.1-7cfkxE9Bq2x7khGuVuQDC7
    aeson-pretty-0.8.10-5fxrLhkA1SsCO3q6H5F8tH
    ansi-terminal-1.0.2-JYusxb73OETHD3sHArHcs
    atomic-write-0.2.1.1-DijVZENt3vOCjzdxNFWlNI base-4.17.2.1
    base16-bytestring-1.0.2.0-GJYqnQXROt0F72VvVyLJpe
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-GQeAlR2AZ5qKSa6EskqV7j
    cborg-0.2.10.0-5UU0yVb70le9mL0iOP07pK
    cborg-json-0.2.6.0-1NAp47kimuIJUbVwAjL1bJ containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-M4sur3VOhr5nr5vcv9tO6
    data-fix-0.3.4-JRPy6XMSABz3hA3MUzO3vc deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-JA8EZxBfxlZ8ZEK30QRc1B exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-KOdZ0xqJmaP9lmeUHo67j2
    hashable-1.4.6.0-YmGjGgSp1PCYD264OAOUA haskeline-0.8.2
    http-client-0.7.19-JmHmaoQUy1C5oiPZXr15YF
    http-client-tls-0.3.6.4-FZfhgXWtSdwFiG9MTCDy82
    http-types-0.12.4-1rtZtKDzV5obVFgF5aFTX
    indexed-traversable-0.1.4-LQVPMqdYEtI3MQSrB8OBIc
    megaparsec-9.7.0-1c2jPx0UmJAAFouxjMyF3D
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-EJq2qAYdDkaFqs6P7Upy96
    optparse-applicative-0.18.1.0-AUOg1zQqVBXHiykDTBb1RQ
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-Jb1JLVdBILrAfqQNBOQVJe
    pretty-simple-4.1.3.0-9dGrevVFOQlKyKTUT1ZPME
    prettyprinter-1.7.1-DU2dJrN5bRm6Aoduk8wHMr
    prettyprinter-ansi-terminal-1.1.3-7KCj1mL67LzLqfzn0Ykct6
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-AOW264DwDbwGkouhllMUCK
    serialise-0.2.6.1-BhCGNwoCLyhFjVjbgGO5X0 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-IT4IcRibSrYCP7MBH9s85
    text-short-0.1.6-CGexu7byjZmGiA63McLIQ2
    th-lift-instances-0.1.20-BqndENyIrp9753iMDopjvO time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-K3sPpbojWsd9DZaxM69rAR
    unordered-containers-0.2.20-7E9U8fDCyyE7V5F5vC663n
    vector-0.13.2.0-62lZRWkkFegAYWIszJUA7I

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

