#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-7oHFJKW8lQF2laMHKoZtZu
key:                  dhall-1.42.2-7oHFJKW8lQF2laMHKoZtZu
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  b43dbfa54bf9f5af5fab02ba29529e5d
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-7oHFJKW8lQF2laMHKoZtZu
depends:
    Diff-0.4.1-KJ48I4npTFjHzRWUMxJmhj
    aeson-2.1.2.1-4XssoWP8s0tKPHSv4bO4jS
    aeson-pretty-0.8.10-GulstWOdB24FAw6bDCaBa1
    ansi-terminal-1.0.2-tIaEKtcHqOD2jCqJ7RqTi
    atomic-write-0.2.1.1-IlnusBIHH0FHINmL4jEuZQ base-4.17.2.1
    base16-bytestring-1.0.2.0-3RDvwOh55ot54GVXP1pwgX
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-DJzIJZH4DdL5KuISGpY4ML
    cborg-0.2.10.0-3o5EcaqCccW84tNeof12u1
    cborg-json-0.2.6.0-8Q8LXwxEbn94oxWjmi3wiy containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-JiYJfDY5o6VFKPB0igZoRs
    data-fix-0.3.4-3WH1Nyn4CDY9ptBqgWwtYB deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-CQREOefkOep2j6SUg8Be0m exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-1biBvHZbJda1wP22Sf0lgc
    hashable-1.4.4.0-D3m6G7BPJON5VQ2FLdROoK haskeline-0.8.2
    http-client-0.7.19-7a4jmx6GqRn5GICVB644F0
    http-client-tls-0.3.6.4-EsZUowlT5rT685ImtnlbYx
    http-types-0.12.4-2RoTdpR4Maj5iH1GQnMeig
    indexed-traversable-0.1.4-HSZPVrJnBqe50DNrlM74QR
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-41F5K5g8jfX9jzQ5gGX83m
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-2wmE2uZDcqIIgHOfFlXQyo
    optparse-applicative-0.18.1.0-1qQAtHv6qKDHnowaperQhI
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-D0YRcz3Yn6T9VYHg8av9Pn
    pretty-simple-4.1.3.0-IcRYmPFo1Y58u9bRDOMoUh
    prettyprinter-1.7.1-5ZQmBmwWcWI11K7a8GbhBl
    prettyprinter-ansi-terminal-1.1.3-BBtZEBIElqGhweUz6FSLq
    profunctors-5.6.3-NWHjCvZ9ZmIe3xLFfwZqp
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-7k94WWHeF91KCJJx1troIA
    serialise-0.2.6.1-GBDZWQpl9IBLac1eQcsDb1 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-93x6UNAm4ADC9FKdOM4x5D
    text-short-0.1.6-1ZjKhXyMGveJXBVMe8ZtNB
    th-lift-instances-0.1.20-IwebiWZ4aGgFgZ9YEdV5Wl time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-EMY80kE8QWvCO803nZuJ6g
    unordered-containers-0.2.20-3371VA61Be1CojVrkG24uM
    vector-0.13.2.0-EWs7nDhBFQF5RfgCWU6KmC

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

