#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-2XAWUPKXodiLiObtOtprtL
key:                  dhall-1.42.2-2XAWUPKXodiLiObtOtprtL
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  5e8bbd7532ad77515fa93bf66afce6ac
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-2XAWUPKXodiLiObtOtprtL
depends:
    Diff-0.4.1-7Fwvr1SqYTt4uBZ7hvolZA
    aeson-2.1.2.1-HUj8Ou2Jrr19darX8iyQt4
    aeson-pretty-0.8.10-8ihe1fW3Pbtu3c4hGPQcH
    ansi-terminal-1.0.2-BmYwE3CMMeiHUDLKLgejP7
    atomic-write-0.2.1.1-5u3XVY3WaHaH6jNRNkvXpY base-4.17.2.1
    base16-bytestring-1.0.2.0-C3cPjjLt0AO1rbHXbT6P0Z
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-JGcld4v8YDLG9iCNMxqnvW
    cborg-0.2.10.0-89Ty74b4MbPGDYWJ6HEU8f
    cborg-json-0.2.6.0-6Yx4dKdTCiZLQAsOTsJz5p containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-qCC3j6usTK8QvKkToMNCt
    data-fix-0.3.4-LcGqGMKSqJWL0Y2W5B7FdX deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-3ucGpqzZEQ8FfeZNWDJLth exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-FYpPW5u5UbsJBQkzAlt611
    hashable-1.4.4.0-C1fFIG7AZLC7j0jzLm97Uw haskeline-0.8.2
    http-client-0.7.18-1ilMUdfjVEzBmOQGNnAaP8
    http-client-tls-0.3.6.4-G572VTUlq1cGiNodxYdpP9
    http-types-0.12.4-22ca4VB3NcX8GYX2Ium30U
    indexed-traversable-0.1.4-2T176InstcMqAaY6WCojl
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-EEBj4pRLerNCeJDumClMn7
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-6QHuxl9r30A5vsu5UpWUoB
    optparse-applicative-0.18.1.0-HLRS0wxhkSb4kVPN7e82uH
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-DErfaxT6lwyB7JqmqUud4T
    pretty-simple-4.1.3.0-CSkeqWsUAPXF6QlYxJ7Vs
    prettyprinter-1.7.1-H0iQpJbBZ6k9IFy5REj5dh
    prettyprinter-ansi-terminal-1.1.3-FhScSTfQH45372MjCmeGhc
    profunctors-5.6.3-8FNppvPYojn1YMtMW6wR6o
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-3JrZTDh3ZlGFN4TNaQrQZi
    serialise-0.2.6.1-IqXlh0WkXg8FFe2FqauIvu template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-9Izrpxit0lDcRum0Legro
    text-short-0.1.6-G05xAmjvzxF6KbLM99PA0Y
    th-lift-instances-0.1.20-Kp8LPCIOGkz6Gqws09r5Lb time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-8PAyJFIzbO7LjuiJWjVyWo
    unordered-containers-0.2.20-obNV32ZSreHxgWRz6JrKP
    vector-0.13.2.0-GDtmlcfK9QZ7E5AlTQVnIi

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

