#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-GO6WbeyGS5e6JOYW7xdBos
key:                  dhall-1.42.2-GO6WbeyGS5e6JOYW7xdBos
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  71865c68ae5ea9d2ace8694d9ce304dc
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-GO6WbeyGS5e6JOYW7xdBos
depends:
    Diff-0.4.1-CBiY4eyeiRQG8RHG96uHG4
    aeson-2.1.2.1-2ooOAwlErgbHj6Tyvuh2I5
    aeson-pretty-0.8.10-J4gOpZ96Ky9EvXv8T6OeEm
    ansi-terminal-1.0.2-6ZbytJewXtEJSCVeiG0zJh
    atomic-write-0.2.1.1-Fk1gmvxHhcg67tfCk5Lwpy base-4.17.2.1
    base16-bytestring-1.0.2.0-LQzuWooFmdALTFyXCNHSon
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-JUsvO4q6QZv9oNQva346P6
    cborg-0.2.10.0-BJ6zVqzPvJq1iQAmp0JvFT
    cborg-json-0.2.6.0-HIBLsQFoEIOF27S7vrONsn containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-Hkwz3NwcZmm1tm3UmckaPb
    data-fix-0.3.4-MvZ5QYUMH23A2Zjpfkrs9 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-Bpo5AxtgmGSBo82vRZStXl exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-65CPxfT66kL7KHVcTfsvaJ
    hashable-1.4.4.0-CTf4tWLvOCwE4B8hp3PoEK haskeline-0.8.2
    http-client-0.7.18-LbIjfqgkVH6EQZrPuBb65p
    http-client-tls-0.3.6.4-AoW9RXZ494d6jfm3w17fZv
    http-types-0.12.4-8FTU05okzyoIwQtiG4S4B5
    indexed-traversable-0.1.4-9eY2jWX2flnImgSA45MGyH
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-5RuoB8ePxKF1XTFOu32khO
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-G7m9o4Qp8JT5z4xQAeqaNT
    optparse-applicative-0.18.1.0-JuQoOrwWN8S21l8m3o2pvN
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-GlcXgK72POlBWcSo2X9bth
    pretty-simple-4.1.3.0-5cJfnoeTliFGpKFWl8C3fg
    prettyprinter-1.7.1-EqfzrdoXeXwBZWVdz9UKUZ
    prettyprinter-ansi-terminal-1.1.3-2kAqCIFmqyI2b54jwtSYDP
    profunctors-5.6.3-3kelvowQ64446mPSwdGk1E
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-Kb5Gqy0LO2R6GqxRC9SGn9
    serialise-0.2.6.1-AqTCj3f6AF04df2xlUlNSP template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-ANYSkWMy1J4J4AJeK95nDU
    text-short-0.1.6-JuParaFlytB3yHsA4QF9zw
    th-lift-instances-0.1.20-9KaTGkFtFDw4yYEjuBLgyM time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-HSgadBBXSpB6KNshGA8sWV
    unordered-containers-0.2.20-5aRSzj1YCHv4h2N6lFa6Hx
    vector-0.13.2.0-BWMo7dqC00725tIPRLs4rJ

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

