#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptol
version:              3.2.0
visibility:           public
id:                   cryptol-3.2.0-K0X96Fa1HpXGPV8WFF3DAs
key:                  cryptol-3.2.0-K0X96Fa1HpXGPV8WFF3DAs
license:              BSD-3-Clause
copyright:            2013-2022 Galois Inc.
maintainer:           cryptol@galois.com
author:               Galois, Inc.
homepage:             http://www.cryptol.net/
synopsis:             Cryptol: The Language of Cryptography
description:
    Cryptol is a domain-specific language for specifying cryptographic algorithms. A Cryptol implementation of an algorithm resembles its mathematical specification more closely than an implementation in a general purpose language. For more, see <http://www.cryptol.net/>.

category:             Language
abi:                  5a98a18f51195811f81a43a13784cd31
exposed:              True
exposed-modules:
    Cryptol.AES Cryptol.Backend Cryptol.Backend.Arch
    Cryptol.Backend.Concrete Cryptol.Backend.FFI
    Cryptol.Backend.FFI.Error Cryptol.Backend.FloatHelpers
    Cryptol.Backend.Monad Cryptol.Backend.SBV Cryptol.Backend.SeqMap
    Cryptol.Backend.What4 Cryptol.Backend.WordValue Cryptol.Eval
    Cryptol.Eval.Concrete Cryptol.Eval.Env Cryptol.Eval.FFI
    Cryptol.Eval.FFI.GenHeader Cryptol.Eval.Generic Cryptol.Eval.Prims
    Cryptol.Eval.Reference Cryptol.Eval.SBV Cryptol.Eval.Type
    Cryptol.Eval.Value Cryptol.Eval.What4 Cryptol.F2
    Cryptol.IR.FreeVars Cryptol.IR.TraverseNames Cryptol.ModuleSystem
    Cryptol.ModuleSystem.Base Cryptol.ModuleSystem.Binds
    Cryptol.ModuleSystem.Env Cryptol.ModuleSystem.Exports
    Cryptol.ModuleSystem.Fingerprint Cryptol.ModuleSystem.Interface
    Cryptol.ModuleSystem.Monad Cryptol.ModuleSystem.Name
    Cryptol.ModuleSystem.Names Cryptol.ModuleSystem.NamingEnv
    Cryptol.ModuleSystem.NamingEnv.Types Cryptol.ModuleSystem.Renamer
    Cryptol.ModuleSystem.Renamer.Error
    Cryptol.ModuleSystem.Renamer.ImplicitImports
    Cryptol.ModuleSystem.Renamer.Imports
    Cryptol.ModuleSystem.Renamer.Monad Cryptol.Parser
    Cryptol.Parser.AST Cryptol.Parser.ExpandPropGuards
    Cryptol.Parser.Layout Cryptol.Parser.Lexer Cryptol.Parser.Name
    Cryptol.Parser.Names Cryptol.Parser.NoInclude Cryptol.Parser.NoPat
    Cryptol.Parser.Position Cryptol.Parser.Selector
    Cryptol.Parser.Token Cryptol.Parser.Unlit Cryptol.Parser.Utils
    Cryptol.PrimeEC Cryptol.REPL.Browse Cryptol.REPL.Command
    Cryptol.REPL.Help Cryptol.REPL.Monad Cryptol.REPL.Trie Cryptol.SHA
    Cryptol.Symbolic Cryptol.Symbolic.SBV Cryptol.Symbolic.What4
    Cryptol.Testing.Random Cryptol.Transform.MonoValues
    Cryptol.Transform.Specialize Cryptol.TypeCheck
    Cryptol.TypeCheck.AST Cryptol.TypeCheck.Default
    Cryptol.TypeCheck.Error Cryptol.TypeCheck.FFI
    Cryptol.TypeCheck.FFI.Error Cryptol.TypeCheck.FFI.FFIType
    Cryptol.TypeCheck.Infer Cryptol.TypeCheck.InferTypes
    Cryptol.TypeCheck.Instantiate Cryptol.TypeCheck.Interface
    Cryptol.TypeCheck.Kind Cryptol.TypeCheck.Module
    Cryptol.TypeCheck.ModuleBacktickInstance
    Cryptol.TypeCheck.ModuleInstance Cryptol.TypeCheck.Monad
    Cryptol.TypeCheck.PP Cryptol.TypeCheck.Parseable
    Cryptol.TypeCheck.Sanity Cryptol.TypeCheck.SimpType
    Cryptol.TypeCheck.SimpleSolver Cryptol.TypeCheck.Solve
    Cryptol.TypeCheck.Solver.Class Cryptol.TypeCheck.Solver.Improve
    Cryptol.TypeCheck.Solver.InfNat Cryptol.TypeCheck.Solver.Numeric
    Cryptol.TypeCheck.Solver.Numeric.Fin
    Cryptol.TypeCheck.Solver.Numeric.Interval
    Cryptol.TypeCheck.Solver.SMT Cryptol.TypeCheck.Solver.Selector
    Cryptol.TypeCheck.Solver.Types Cryptol.TypeCheck.Solver.Utils
    Cryptol.TypeCheck.Subst Cryptol.TypeCheck.TCon
    Cryptol.TypeCheck.Type Cryptol.TypeCheck.TypeMap
    Cryptol.TypeCheck.TypeOf Cryptol.TypeCheck.TypePat
    Cryptol.TypeCheck.Unify Cryptol.Utils.Benchmark Cryptol.Utils.Debug
    Cryptol.Utils.Fixity Cryptol.Utils.Ident Cryptol.Utils.Logger
    Cryptol.Utils.Misc Cryptol.Utils.PP Cryptol.Utils.Panic
    Cryptol.Utils.Patterns Cryptol.Utils.RecordMap Cryptol.Utils.Types
    Cryptol.Version

hidden-modules:
    Cryptol.Parser.LexerUtils Cryptol.Parser.ParserUtils
    Cryptol.Prelude GHC.Num.Compat Paths_cryptol GitRev

import-dirs:          /usr/lib/ghc-9.4.8/site-local/cryptol-3.2.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cryptol-3.2.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cryptol-3.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/cryptol
hs-libraries:         HScryptol-3.2.0-K0X96Fa1HpXGPV8WFF3DAs
depends:
    GraphSCC-1.0.4-BvH3gdGqztj6roihacPJAg
    MemoTrie-0.6.11-C7egoOBCOt7AThwanBrdHy
    arithmoi-0.13.1.0-C7a24R3X2Y457rR5UgRglK array-0.5.4.0
    async-2.2.5-GA6qhjC24ND8PxBPqYF6rT base-4.17.2.1
    base-compat-0.13.1-8jgXJjtFto7AX0ry1QXDcA
    bv-sized-1.0.6-F3F95XVv13X5EY2gnBX9XX bytestring-0.11.5.3
    containers-0.6.7
    criterion-measurement-0.2.3.0-3phaEEexHq6AGf3IQ5Qp9s
    cryptohash-sha1-0.11.101.0-HDuWPZIiwjDpk7jh5sWTt deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    ghc-bignum-1.3 ghc-prim-0.9.1 gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hgmp-0.1.2.1-8Nd31JXKKEB5E1JcBr2rsw
    language-c99-0.2.0-I2YO1ITQKgi7h1b2QKXgRh
    language-c99-simple-0.3.0-LtsnH0LVnu56Mhd4fxlDo
    libBF-0.6.6-D8iSkM3dqRM2EnaxXWtTij
    libffi-0.2.1-DPsLfzr2gvt1V2FBULxP58
    monad-control-1.0.3.1-Gznm0l8Lbkh1N6Qfynm2B4
    monadLib-3.10.3-9u69WCWPr5d93B1By2kxXa mtl-2.2.2
    panic-0.4.0.1-Jq9VAg5hh1m6c8kWsB4pox
    parameterized-utils-2.1.10.0-291WelLIn5CB1rKlm8bP3u pretty-1.1.3.6
    pretty-show-1.10-Ey6CADemQl3EFi7OIHqHDp
    prettyprinter-1.7.1-2R6NgwfUgVc9iM5YqEeKHX process-1.6.18.0
    sbv-10.2-4X7Tl6pYBFT9VpVJ689d7Y
    simple-smt-0.9.8-GxJMYuz27wdJmfDJ6DG7cL stm-2.5.1.0
    strict-0.5-JoMUYyNiaM53qdwe1ZN6qo text-2.0.2
    tf-random-0.5-I3Ne6PR1M0Zr7bJN2MABF time-1.12.2
    transformers-base-0.4.6-9kDn83Yy5E7DotDycldsLa unix-2.7.3
    vector-0.13.2.0-7jLyylqham1Ij3AknS5IxU
    what4-1.6-7OOqHX4DUIKGodVvyDh7Gw

haddock-interfaces:   /usr/share/doc/cryptol/html/cryptol.haddock
haddock-html:         /usr/share/doc/cryptol/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

