// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { RestError as TspRestError, isRestError as tspIsRestError, } from "@typespec/ts-http-runtime";
/**
 * A custom error type for failed pipeline requests.
 */
// eslint-disable-next-line @typescript-eslint/no-redeclare
export const RestError = TspRestError;
/**
 * Typeguard for RestError
 * @param e - Something caught by a catch clause.
 */
export function isRestError(e) {
    return tspIsRestError(e);
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/6f17636121051a53c88d3e605c491d22af2ba755/node_modules/@azure/core-rest-pipeline/dist/browser/restError.js.map