#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clash-ghc
version:              1.8.2
visibility:           public
id:                   clash-ghc-1.8.2-5km9xWYOMlTEHqDiQUvhc6
key:                  clash-ghc-1.8.2-5km9xWYOMlTEHqDiQUvhc6
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - GHC frontend

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Clash Compiler binary using GHC/Haskell as a frontend


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  719ca0310014da804a4daa7ae9423ea1
exposed:              True
exposed-modules:
    Clash.GHC.Evaluator Clash.GHC.Evaluator.Primitive
    Clash.GHC.GenerateBindings Clash.GHC.LoadModules
    Clash.GHC.NetlistTypes Clash.GHC.PartialEval
    Clash.GHC.PartialEval.Eval Clash.GHC.PartialEval.Primitive
    Clash.GHC.PartialEval.Quote Clash.GHCi.Common Clash.Main

hidden-modules:
    Clash.GHCi.Leak Clash.GHCi.UI Clash.GHCi.UI.Info
    Clash.GHCi.UI.Monad Clash.GHC.ClashFlags Clash.GHC.GHC2Core
    Clash.GHC.LoadInterfaceFiles Clash.GHC.Util Data.Text.Extra
    Paths_clash_ghc Clash.GHCi.Util Clash.GHCi.UI.Tags

import-dirs:          /usr/lib/ghc-9.4.8/site-local/clash-ghc-1.8.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/clash-ghc-1.8.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/clash-ghc-1.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/clash-ghc
hs-libraries:         HSclash-ghc-1.8.2-5km9xWYOMlTEHqDiQUvhc6
depends:
    Cabal-3.8.1.0 array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3
    clash-lib-1.8.2-C3BO04XIGKG60ZSCf82BOv
    clash-prelude-1.8.2-ETmvw018Pv9ITluk3dzVzJ containers-0.6.7
    data-binary-ieee754-0.4.4-3K4wyZ8KRa1CgKftL8GYsk deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5
    extra-1.7.16-EVqIvjfjup2KjWh1SyzBng filepath-1.4.2.2 ghc-9.4.8
    ghc-bignum-1.3 ghc-boot-9.4.8 ghc-prim-0.9.1
    ghc-typelits-extra-0.4.5-3OeNVGxND1IDGR967KN4Wo
    ghc-typelits-knownnat-0.7.10-3Z8OrHLdZc34FRjjGrGbi9
    ghc-typelits-natnormalise-0.7.10-KBWtcxbdiXy8sI8uysoU7u ghci-9.4.8
    hashable-1.4.4.0-85lkkmOSRZHDIzkr9EkKNp haskeline-0.8.2
    lens-5.3-FNJYFG5nVy3K1UtPWTWg2x mtl-2.2.2
    primitive-0.9.1.0-KawCla5BA6F2MLtBZRS1Dh process-1.6.18.0
    reflection-2.1.9-JhysDEKTSOlL6iRbRMYxoe
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    string-interpolate-0.3.4.0-I7ok06579NPHiwd6y8kq3f
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 uniplate-1.6.13-98fOhlqW0XqJefmRDJ9Z2w
    unix-2.7.3 unordered-containers-0.2.20-Cw2Ec4BgC4sInKE4e5RLSk
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    vector-0.13.2.0-3jopdCx3MMLHVSrvHoDH9i

haddock-interfaces:   /usr/share/doc/clash-ghc/html/clash-ghc.haddock
haddock-html:         /usr/share/doc/clash-ghc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

