#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 BNFC
version:              2.9.6.1
visibility:           public
id:                   BNFC-2.9.6.1-LDqumrR5zmrSZT283oCAO
key:                  BNFC-2.9.6.1-LDqumrR5zmrSZT283oCAO
license:              BSD-3-Clause
copyright:
    (c) Andreas Abel, Jonas Almström Duregård, Krasimir Angelov, Jean-Philippe Bernardy, Björn Bringert, Johan Broberg, Kyle Butt, Paul Callaghan, Grégoire Détrez, Markus Forsberg, Ola Frid, Peter Gammie, Thomas Hallgren, Pascal Hof, Simon Huber, Patrik Jansson, Kristofer Johannisson, Antti-Juhani Kaijanaho, Andreas Lööw, Justin Meiners, Kent Mein, Ulf Norell, Gabriele Paganelli, Michael Pellauer, Michał Radwański, Fabian Ruch, and Aarne Ranta 2002 - 2023. Free software under the BSD 3-clause license.

maintainer:           bnfc-dev@googlegroups.com
homepage:             https://bnfc.digitalgrammars.com/
synopsis:             A compiler front-end generator.
description:
    The BNF Converter is a compiler construction tool generating a compiler front-end
    from a Labelled BNF grammar. It was originally written to generate Haskell code,
    but can also be used for generating Agda, C, C++, Java, Ocaml and XML code.

    Given a Labelled BNF grammar the tool produces:
    an abstract syntax as a Haskell, Agda, C, C++, Ocaml module or Java package,
    a case skeleton for the abstract syntax in the same language,
    an Alex, Flex, JLex, JFlex, or ocamllex lexer generator file,
    a Happy, CUP, Bison, Antlr, ocamlyacc or menhir parser generator file,
    a pretty-printer as a Haskell, Agda, C, C++, Java, or Ocaml module,
    an XML representation,
    a LaTeX file containing a readable specification of the language.

category:             Parsing
abi:                  68127045e1e49ca08d76bf117c4a9721
exposed:              True
exposed-modules:
    BNFC.Abs BNFC.Backend.Agda BNFC.Backend.Base BNFC.Backend.C
    BNFC.Backend.C.CFtoBisonC BNFC.Backend.C.CFtoCAbs
    BNFC.Backend.C.CFtoCPrinter BNFC.Backend.C.CFtoCSkel
    BNFC.Backend.C.CFtoFlexC BNFC.Backend.C.Common
    BNFC.Backend.C.RegToFlex BNFC.Backend.CPP.Common
    BNFC.Backend.CPP.Makefile BNFC.Backend.CPP.Naming
    BNFC.Backend.CPP.NoSTL BNFC.Backend.CPP.NoSTL.CFtoCPPAbs
    BNFC.Backend.CPP.PrettyPrinter BNFC.Backend.CPP.STL
    BNFC.Backend.CPP.STL.CFtoCVisitSkelSTL
    BNFC.Backend.CPP.STL.CFtoSTLAbs BNFC.Backend.CPP.STL.STLUtils
    BNFC.Backend.Common BNFC.Backend.Common.Makefile
    BNFC.Backend.Common.NamedVariables BNFC.Backend.Common.OOAbstract
    BNFC.Backend.Common.StrUtils BNFC.Backend.Haskell
    BNFC.Backend.Haskell.CFtoAbstract BNFC.Backend.Haskell.CFtoAlex3
    BNFC.Backend.Haskell.CFtoHappy BNFC.Backend.Haskell.CFtoLayout
    BNFC.Backend.Haskell.CFtoPrinter BNFC.Backend.Haskell.CFtoTemplate
    BNFC.Backend.Haskell.HsOpts BNFC.Backend.Haskell.MkErrM
    BNFC.Backend.Haskell.Utils BNFC.Backend.HaskellGADT
    BNFC.Backend.HaskellGADT.CFtoAbstractGADT
    BNFC.Backend.HaskellGADT.CFtoTemplateGADT
    BNFC.Backend.HaskellGADT.HaskellGADTCommon BNFC.Backend.Java
    BNFC.Backend.Java.CFtoAbstractVisitor
    BNFC.Backend.Java.CFtoAllVisitor BNFC.Backend.Java.CFtoAntlr4Lexer
    BNFC.Backend.Java.CFtoAntlr4Parser
    BNFC.Backend.Java.CFtoComposVisitor BNFC.Backend.Java.CFtoCup15
    BNFC.Backend.Java.CFtoFoldVisitor BNFC.Backend.Java.CFtoJLex15
    BNFC.Backend.Java.CFtoJavaAbs15 BNFC.Backend.Java.CFtoJavaPrinter15
    BNFC.Backend.Java.CFtoVisitSkel15 BNFC.Backend.Java.RegToAntlrLexer
    BNFC.Backend.Java.RegToJLex BNFC.Backend.Java.Utils
    BNFC.Backend.Latex BNFC.Backend.OCaml
    BNFC.Backend.OCaml.CFtoOCamlAbs BNFC.Backend.OCaml.CFtoOCamlLex
    BNFC.Backend.OCaml.CFtoOCamlPrinter
    BNFC.Backend.OCaml.CFtoOCamlShow
    BNFC.Backend.OCaml.CFtoOCamlTemplate
    BNFC.Backend.OCaml.CFtoOCamlTest BNFC.Backend.OCaml.CFtoOCamlYacc
    BNFC.Backend.OCaml.OCamlUtil BNFC.Backend.Pygments
    BNFC.Backend.TreeSitter BNFC.Backend.TreeSitter.CFtoTreeSitter
    BNFC.Backend.TreeSitter.RegToJSReg BNFC.Backend.Txt2Tag
    BNFC.Backend.XML BNFC.CF BNFC.Check.EmptyTypes BNFC.GetCF BNFC.Lex
    BNFC.Lexing BNFC.License BNFC.Options BNFC.Par BNFC.PrettyPrint
    BNFC.Print BNFC.Regex BNFC.TypeChecker BNFC.Utils

hidden-modules:       Paths_BNFC
import-dirs:          /usr/lib/ghc-9.4.8/site-local/BNFC-2.9.6.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/BNFC-2.9.6.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/BNFC-2.9.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/bnfc
hs-libraries:         HSBNFC-2.9.6.1-LDqumrR5zmrSZT283oCAO
depends:
    array-0.5.4.0 base-4.17.2.1 containers-0.6.7 deepseq-1.4.8.0
    directory-1.3.7.1 filepath-1.4.2.2 mtl-2.2.2 pretty-1.1.3.6
    process-1.6.18.0 string-qq-0.0.6-IHvlyMH81tGHpfdvl5JwKV time-1.12.2
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/bnfc/html/BNFC.haddock
haddock-html:         /usr/share/doc/bnfc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

