﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/bedrock-agent/model/PromptSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace BedrockAgent
{
namespace Model
{
  class ListPromptsResult
  {
  public:
    AWS_BEDROCKAGENT_API ListPromptsResult() = default;
    AWS_BEDROCKAGENT_API ListPromptsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_BEDROCKAGENT_API ListPromptsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list, each member of which contains information about a prompt using Prompt
     * management.</p>
     */
    inline const Aws::Vector<PromptSummary>& GetPromptSummaries() const { return m_promptSummaries; }
    template<typename PromptSummariesT = Aws::Vector<PromptSummary>>
    void SetPromptSummaries(PromptSummariesT&& value) { m_promptSummariesHasBeenSet = true; m_promptSummaries = std::forward<PromptSummariesT>(value); }
    template<typename PromptSummariesT = Aws::Vector<PromptSummary>>
    ListPromptsResult& WithPromptSummaries(PromptSummariesT&& value) { SetPromptSummaries(std::forward<PromptSummariesT>(value)); return *this;}
    template<typename PromptSummariesT = PromptSummary>
    ListPromptsResult& AddPromptSummaries(PromptSummariesT&& value) { m_promptSummariesHasBeenSet = true; m_promptSummaries.emplace_back(std::forward<PromptSummariesT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>If the total number of results is greater than the <code>maxResults</code>
     * value provided in the request, use this token when making another request in the
     * <code>nextToken</code> field to return the next batch of results.</p>
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    ListPromptsResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    ListPromptsResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<PromptSummary> m_promptSummaries;
    bool m_promptSummariesHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace BedrockAgent
} // namespace Aws
