﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/neptunedata/Neptunedata_EXPORTS.h>
#include <aws/neptunedata/NeptunedataRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/neptunedata/model/CustomModelTransformParameters.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace neptunedata
{
namespace Model
{

  /**
   */
  class StartMLModelTransformJobRequest : public NeptunedataRequest
  {
  public:
    AWS_NEPTUNEDATA_API StartMLModelTransformJobRequest() = default;

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "StartMLModelTransformJob"; }

    AWS_NEPTUNEDATA_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>A unique identifier for the new job. The default is an autogenerated
     * UUID.</p>
     */
    inline const Aws::String& GetId() const { return m_id; }
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
    template<typename IdT = Aws::String>
    void SetId(IdT&& value) { m_idHasBeenSet = true; m_id = std::forward<IdT>(value); }
    template<typename IdT = Aws::String>
    StartMLModelTransformJobRequest& WithId(IdT&& value) { SetId(std::forward<IdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job ID of a completed data-processing job. You must include either
     * <code>dataProcessingJobId</code> and a <code>mlModelTrainingJobId</code>, or a
     * <code>trainingJobName</code>.</p>
     */
    inline const Aws::String& GetDataProcessingJobId() const { return m_dataProcessingJobId; }
    inline bool DataProcessingJobIdHasBeenSet() const { return m_dataProcessingJobIdHasBeenSet; }
    template<typename DataProcessingJobIdT = Aws::String>
    void SetDataProcessingJobId(DataProcessingJobIdT&& value) { m_dataProcessingJobIdHasBeenSet = true; m_dataProcessingJobId = std::forward<DataProcessingJobIdT>(value); }
    template<typename DataProcessingJobIdT = Aws::String>
    StartMLModelTransformJobRequest& WithDataProcessingJobId(DataProcessingJobIdT&& value) { SetDataProcessingJobId(std::forward<DataProcessingJobIdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job ID of a completed model-training job. You must include either
     * <code>dataProcessingJobId</code> and a <code>mlModelTrainingJobId</code>, or a
     * <code>trainingJobName</code>.</p>
     */
    inline const Aws::String& GetMlModelTrainingJobId() const { return m_mlModelTrainingJobId; }
    inline bool MlModelTrainingJobIdHasBeenSet() const { return m_mlModelTrainingJobIdHasBeenSet; }
    template<typename MlModelTrainingJobIdT = Aws::String>
    void SetMlModelTrainingJobId(MlModelTrainingJobIdT&& value) { m_mlModelTrainingJobIdHasBeenSet = true; m_mlModelTrainingJobId = std::forward<MlModelTrainingJobIdT>(value); }
    template<typename MlModelTrainingJobIdT = Aws::String>
    StartMLModelTransformJobRequest& WithMlModelTrainingJobId(MlModelTrainingJobIdT&& value) { SetMlModelTrainingJobId(std::forward<MlModelTrainingJobIdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of a completed SageMaker training job. You must include either
     * <code>dataProcessingJobId</code> and a <code>mlModelTrainingJobId</code>, or a
     * <code>trainingJobName</code>.</p>
     */
    inline const Aws::String& GetTrainingJobName() const { return m_trainingJobName; }
    inline bool TrainingJobNameHasBeenSet() const { return m_trainingJobNameHasBeenSet; }
    template<typename TrainingJobNameT = Aws::String>
    void SetTrainingJobName(TrainingJobNameT&& value) { m_trainingJobNameHasBeenSet = true; m_trainingJobName = std::forward<TrainingJobNameT>(value); }
    template<typename TrainingJobNameT = Aws::String>
    StartMLModelTransformJobRequest& WithTrainingJobName(TrainingJobNameT&& value) { SetTrainingJobName(std::forward<TrainingJobNameT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The location in Amazon S3 where the model artifacts are to be stored.</p>
     */
    inline const Aws::String& GetModelTransformOutputS3Location() const { return m_modelTransformOutputS3Location; }
    inline bool ModelTransformOutputS3LocationHasBeenSet() const { return m_modelTransformOutputS3LocationHasBeenSet; }
    template<typename ModelTransformOutputS3LocationT = Aws::String>
    void SetModelTransformOutputS3Location(ModelTransformOutputS3LocationT&& value) { m_modelTransformOutputS3LocationHasBeenSet = true; m_modelTransformOutputS3Location = std::forward<ModelTransformOutputS3LocationT>(value); }
    template<typename ModelTransformOutputS3LocationT = Aws::String>
    StartMLModelTransformJobRequest& WithModelTransformOutputS3Location(ModelTransformOutputS3LocationT&& value) { SetModelTransformOutputS3Location(std::forward<ModelTransformOutputS3LocationT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ARN of an IAM role for SageMaker execution. This must be listed in your
     * DB cluster parameter group or an error will occur.</p>
     */
    inline const Aws::String& GetSagemakerIamRoleArn() const { return m_sagemakerIamRoleArn; }
    inline bool SagemakerIamRoleArnHasBeenSet() const { return m_sagemakerIamRoleArnHasBeenSet; }
    template<typename SagemakerIamRoleArnT = Aws::String>
    void SetSagemakerIamRoleArn(SagemakerIamRoleArnT&& value) { m_sagemakerIamRoleArnHasBeenSet = true; m_sagemakerIamRoleArn = std::forward<SagemakerIamRoleArnT>(value); }
    template<typename SagemakerIamRoleArnT = Aws::String>
    StartMLModelTransformJobRequest& WithSagemakerIamRoleArn(SagemakerIamRoleArnT&& value) { SetSagemakerIamRoleArn(std::forward<SagemakerIamRoleArnT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
     * S3 resources. This must be listed in your DB cluster parameter group or an error
     * will occur.</p>
     */
    inline const Aws::String& GetNeptuneIamRoleArn() const { return m_neptuneIamRoleArn; }
    inline bool NeptuneIamRoleArnHasBeenSet() const { return m_neptuneIamRoleArnHasBeenSet; }
    template<typename NeptuneIamRoleArnT = Aws::String>
    void SetNeptuneIamRoleArn(NeptuneIamRoleArnT&& value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn = std::forward<NeptuneIamRoleArnT>(value); }
    template<typename NeptuneIamRoleArnT = Aws::String>
    StartMLModelTransformJobRequest& WithNeptuneIamRoleArn(NeptuneIamRoleArnT&& value) { SetNeptuneIamRoleArn(std::forward<NeptuneIamRoleArnT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Configuration information for a model transform using a custom model. The
     * <code>customModelTransformParameters</code> object contains the following
     * fields, which must have values compatible with the saved model parameters from
     * the training job:</p>
     */
    inline const CustomModelTransformParameters& GetCustomModelTransformParameters() const { return m_customModelTransformParameters; }
    inline bool CustomModelTransformParametersHasBeenSet() const { return m_customModelTransformParametersHasBeenSet; }
    template<typename CustomModelTransformParametersT = CustomModelTransformParameters>
    void SetCustomModelTransformParameters(CustomModelTransformParametersT&& value) { m_customModelTransformParametersHasBeenSet = true; m_customModelTransformParameters = std::forward<CustomModelTransformParametersT>(value); }
    template<typename CustomModelTransformParametersT = CustomModelTransformParameters>
    StartMLModelTransformJobRequest& WithCustomModelTransformParameters(CustomModelTransformParametersT&& value) { SetCustomModelTransformParameters(std::forward<CustomModelTransformParametersT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of ML instance used in preparing and managing training of ML models.
     * This is an ML compute instance chosen based on memory requirements for
     * processing the training data and model.</p>
     */
    inline const Aws::String& GetBaseProcessingInstanceType() const { return m_baseProcessingInstanceType; }
    inline bool BaseProcessingInstanceTypeHasBeenSet() const { return m_baseProcessingInstanceTypeHasBeenSet; }
    template<typename BaseProcessingInstanceTypeT = Aws::String>
    void SetBaseProcessingInstanceType(BaseProcessingInstanceTypeT&& value) { m_baseProcessingInstanceTypeHasBeenSet = true; m_baseProcessingInstanceType = std::forward<BaseProcessingInstanceTypeT>(value); }
    template<typename BaseProcessingInstanceTypeT = Aws::String>
    StartMLModelTransformJobRequest& WithBaseProcessingInstanceType(BaseProcessingInstanceTypeT&& value) { SetBaseProcessingInstanceType(std::forward<BaseProcessingInstanceTypeT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The disk volume size of the training instance in gigabytes. The default is 0.
     * Both input data and the output model are stored on disk, so the volume size must
     * be large enough to hold both data sets. If not specified or 0, Neptune ML
     * selects a disk volume size based on the recommendation generated in the data
     * processing step.</p>
     */
    inline int GetBaseProcessingInstanceVolumeSizeInGB() const { return m_baseProcessingInstanceVolumeSizeInGB; }
    inline bool BaseProcessingInstanceVolumeSizeInGBHasBeenSet() const { return m_baseProcessingInstanceVolumeSizeInGBHasBeenSet; }
    inline void SetBaseProcessingInstanceVolumeSizeInGB(int value) { m_baseProcessingInstanceVolumeSizeInGBHasBeenSet = true; m_baseProcessingInstanceVolumeSizeInGB = value; }
    inline StartMLModelTransformJobRequest& WithBaseProcessingInstanceVolumeSizeInGB(int value) { SetBaseProcessingInstanceVolumeSizeInGB(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The IDs of the subnets in the Neptune VPC. The default is None.</p>
     */
    inline const Aws::Vector<Aws::String>& GetSubnets() const { return m_subnets; }
    inline bool SubnetsHasBeenSet() const { return m_subnetsHasBeenSet; }
    template<typename SubnetsT = Aws::Vector<Aws::String>>
    void SetSubnets(SubnetsT&& value) { m_subnetsHasBeenSet = true; m_subnets = std::forward<SubnetsT>(value); }
    template<typename SubnetsT = Aws::Vector<Aws::String>>
    StartMLModelTransformJobRequest& WithSubnets(SubnetsT&& value) { SetSubnets(std::forward<SubnetsT>(value)); return *this;}
    template<typename SubnetsT = Aws::String>
    StartMLModelTransformJobRequest& AddSubnets(SubnetsT&& value) { m_subnetsHasBeenSet = true; m_subnets.emplace_back(std::forward<SubnetsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The VPC security group IDs. The default is None.</p>
     */
    inline const Aws::Vector<Aws::String>& GetSecurityGroupIds() const { return m_securityGroupIds; }
    inline bool SecurityGroupIdsHasBeenSet() const { return m_securityGroupIdsHasBeenSet; }
    template<typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
    void SetSecurityGroupIds(SecurityGroupIdsT&& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds = std::forward<SecurityGroupIdsT>(value); }
    template<typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
    StartMLModelTransformJobRequest& WithSecurityGroupIds(SecurityGroupIdsT&& value) { SetSecurityGroupIds(std::forward<SecurityGroupIdsT>(value)); return *this;}
    template<typename SecurityGroupIdsT = Aws::String>
    StartMLModelTransformJobRequest& AddSecurityGroupIds(SecurityGroupIdsT&& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds.emplace_back(std::forward<SecurityGroupIdsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt
     * data on the storage volume attached to the ML compute instances that run the
     * training job. The default is None.</p>
     */
    inline const Aws::String& GetVolumeEncryptionKMSKey() const { return m_volumeEncryptionKMSKey; }
    inline bool VolumeEncryptionKMSKeyHasBeenSet() const { return m_volumeEncryptionKMSKeyHasBeenSet; }
    template<typename VolumeEncryptionKMSKeyT = Aws::String>
    void SetVolumeEncryptionKMSKey(VolumeEncryptionKMSKeyT&& value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey = std::forward<VolumeEncryptionKMSKeyT>(value); }
    template<typename VolumeEncryptionKMSKeyT = Aws::String>
    StartMLModelTransformJobRequest& WithVolumeEncryptionKMSKey(VolumeEncryptionKMSKeyT&& value) { SetVolumeEncryptionKMSKey(std::forward<VolumeEncryptionKMSKeyT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt
     * the output of the processing job. The default is none.</p>
     */
    inline const Aws::String& GetS3OutputEncryptionKMSKey() const { return m_s3OutputEncryptionKMSKey; }
    inline bool S3OutputEncryptionKMSKeyHasBeenSet() const { return m_s3OutputEncryptionKMSKeyHasBeenSet; }
    template<typename S3OutputEncryptionKMSKeyT = Aws::String>
    void SetS3OutputEncryptionKMSKey(S3OutputEncryptionKMSKeyT&& value) { m_s3OutputEncryptionKMSKeyHasBeenSet = true; m_s3OutputEncryptionKMSKey = std::forward<S3OutputEncryptionKMSKeyT>(value); }
    template<typename S3OutputEncryptionKMSKeyT = Aws::String>
    StartMLModelTransformJobRequest& WithS3OutputEncryptionKMSKey(S3OutputEncryptionKMSKeyT&& value) { SetS3OutputEncryptionKMSKey(std::forward<S3OutputEncryptionKMSKeyT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    Aws::String m_dataProcessingJobId;
    bool m_dataProcessingJobIdHasBeenSet = false;

    Aws::String m_mlModelTrainingJobId;
    bool m_mlModelTrainingJobIdHasBeenSet = false;

    Aws::String m_trainingJobName;
    bool m_trainingJobNameHasBeenSet = false;

    Aws::String m_modelTransformOutputS3Location;
    bool m_modelTransformOutputS3LocationHasBeenSet = false;

    Aws::String m_sagemakerIamRoleArn;
    bool m_sagemakerIamRoleArnHasBeenSet = false;

    Aws::String m_neptuneIamRoleArn;
    bool m_neptuneIamRoleArnHasBeenSet = false;

    CustomModelTransformParameters m_customModelTransformParameters;
    bool m_customModelTransformParametersHasBeenSet = false;

    Aws::String m_baseProcessingInstanceType;
    bool m_baseProcessingInstanceTypeHasBeenSet = false;

    int m_baseProcessingInstanceVolumeSizeInGB{0};
    bool m_baseProcessingInstanceVolumeSizeInGBHasBeenSet = false;

    Aws::Vector<Aws::String> m_subnets;
    bool m_subnetsHasBeenSet = false;

    Aws::Vector<Aws::String> m_securityGroupIds;
    bool m_securityGroupIdsHasBeenSet = false;

    Aws::String m_volumeEncryptionKMSKey;
    bool m_volumeEncryptionKMSKeyHasBeenSet = false;

    Aws::String m_s3OutputEncryptionKMSKey;
    bool m_s3OutputEncryptionKMSKeyHasBeenSet = false;
  };

} // namespace Model
} // namespace neptunedata
} // namespace Aws
