#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-LDGV9fI1QXLKIPoGvMuHTs
key:                  arch-hs-0.12.1-LDGV9fI1QXLKIPoGvMuHTs
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  f8a266c41426311cdc5c662746286a2d
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-LDGV9fI1QXLKIPoGvMuHTs
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-CuN0gcwErnxTovm8uRK5M
    aeson-2.1.2.1-U8Qicry0zF1f9E1tHxOto
    algebraic-graphs-0.7-7UlDKJKx2kyLmcDG9QmI5o
    arch-web-0.3.2-EfqMavLOUsW9HrKjmCw3z base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-JCExIuyhnVmH352zfSD7FS
    conduit-extra-1.3.8-E2T0R9dVEp0LoFKbSS1RVP containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-KIoGT4n3LA6q1pm1mjdI5
    http-client-0.7.19-LmgoxlGljmmJ4yfMmVG9tj
    http-client-tls-0.3.6.4-CWf1zUvMsiN34DRbq0lWlt
    megaparsec-9.7.0-6vU2vxyqrAyGY5juwv0O1p
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-5Go3kNgpiX02ATjmS4M8kO
    optparse-simple-0.1.1.4-80HkWwATdHj5oqkOmM2vnT
    polysemy-1.9.2.0-FMZBxeLhBM43L4UBoOCOIV
    prettyprinter-1.7.1-7cHMA52o3usJvB7pVINYaP
    prettyprinter-ansi-terminal-1.1.3-KBc7B4rdJaz2aaKpFfwo1G
    servant-client-0.20.3.0-CHww4h5j6uLANBXmalvwkW
    split-0.2.5-LouByQg2aGcJvOHmCntrU0
    tar-conduit-0.4.1-1kKsJCsNlMVFUQhOFm8RST template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

