#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.4
visibility:           public
id:                   arch-hs-0.12.0.4-6E3wrMZtDStGkaVscRoFB9
key:                  arch-hs-0.12.0.4-6E3wrMZtDStGkaVscRoFB9
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  362b02bdc3b7f54459fd25e334b973fa
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.4-6E3wrMZtDStGkaVscRoFB9
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-6F2RzRAF4vMBbZwUZsGcD0
    aeson-2.1.2.1-KxhFBZPQYXiG3TO3nhA4Kq
    algebraic-graphs-0.7-E3ec8fKEw7A5ubHe5V9hBO
    arch-web-0.3.1-JCZCzlQboKw2qJBCm0n3b3 base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-KIgc8u8jbkN2A9El9r6mby
    conduit-extra-1.3.8-7AsukhXAhG9EP9Xj5iNAEL containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-2YpTKcakrQO5rDA5FzUPZZ
    http-client-0.7.19-5xqtlAuv10Ciu8xvmO6iF
    http-client-tls-0.3.6.4-IZdKaCSx74jCuO4bihyNpT
    megaparsec-9.7.0-Hsn4IAkVRB2A2QgsJUzrvG
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-ChtzL7AhtYlG5zt92Umwv6
    optparse-simple-0.1.1.4-BvSoF1WJDVgC7lYaFOigmR
    polysemy-1.9.2.0-FfItvcbDEDVLw4352FOYmp
    prettyprinter-1.7.1-Fh4Rajbxlmi9sLGTMcb6xB
    prettyprinter-ansi-terminal-1.1.3-GETXCQhkBIhAanrksF7n2H
    servant-client-0.20.2-8W1UQ8NcaZuKlemf8JIrmd
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    tar-conduit-0.4.1-9OfDRBuYDES2vCrwQBzMWL template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

