#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.4
visibility:           public
id:                   arch-hs-0.12.0.4-9nrq5WRIeAwLnTbbXl91wS
key:                  arch-hs-0.12.0.4-9nrq5WRIeAwLnTbbXl91wS
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  49df889d7f17877d6db764666cdfd4f6
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.4-9nrq5WRIeAwLnTbbXl91wS
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-Jwj4OLAfw0yEVliC3dyBin
    aeson-2.1.2.1-8kv8xeVfmZaCzdZG9aqfKb
    algebraic-graphs-0.7-4eWZvKnSZHaB0JSiQUoJiU
    arch-web-0.3.1-Amfeu5ahXjrFIbqwNhuxRc base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-He7eBVLUt4xGGZqD48fwnz
    conduit-extra-1.3.8-FPYZ2SHai5SFHdZmLa2NAW containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-FbFwYKd9Q609W6y5qkvvLN
    http-client-0.7.19-4PBxl7ykGvY1A1M3m4syiA
    http-client-tls-0.3.6.4-8XU3sE2WrKcAyR7Z9nyH2W
    megaparsec-9.7.0-1voytdgo3wjFoCwR6CT9gz
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-LJwY45iXE8V4XsI327CAeH
    optparse-simple-0.1.1.4-6OX74cKJpp0KXo3Utgpgrq
    polysemy-1.9.2.0-Azd7Dx4uFquGTxLD3URiPf
    prettyprinter-1.7.1-JBUxpob9pPVLD8OaO2d4B1
    prettyprinter-ansi-terminal-1.1.3-DPjP9lcwT5a9DsbOdvTpk3
    servant-client-0.20.2-HzNVuH2mdLs46wpbf1aDdm
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    tar-conduit-0.4.1-Fyd9aYeNljy5hx7wgP3fSj template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

