#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.4
visibility:           public
id:                   arch-hs-0.12.0.4-KdLWLcmW98YIgNpR1I44cy
key:                  arch-hs-0.12.0.4-KdLWLcmW98YIgNpR1I44cy
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  7ba5cf2d761ce68b0f6e04e1093c6e79
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.4-KdLWLcmW98YIgNpR1I44cy
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-ET3XsIdmMuHEEbo255V0kN
    aeson-2.1.2.1-H1ahbkp4Y7o4mfa4dlXJ2M
    algebraic-graphs-0.7-AiZjh9A7Pqa5VZZeBBwMit
    arch-web-0.3.1-3V5H203AfwJ7ngo3xflr3A base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-Ft7mdP42es1IIbhkIhPjly
    conduit-extra-1.3.8-5HT9AVw3Boi2agSmskZi4i containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-6lxNLDavOKi3gYq7q3RWHP
    http-client-0.7.19-CGAsSsow8VECPfkY594gg8
    http-client-tls-0.3.6.4-ADgMftrIfn84MlVUzQaPAi
    megaparsec-9.7.0-KfxQnMxH7036P9QuPFea8D
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-2mZJis19FQG4pLqyJ0Mh1S
    optparse-simple-0.1.1.4-54I2wjqW3wp8vZ1s9AySUF
    polysemy-1.9.2.0-DRL5LuOepTmJAUKt6cms84
    prettyprinter-1.7.1-27Ta3g9m3VQHgx6FjDiyXu
    prettyprinter-ansi-terminal-1.1.3-DxfNV5472scK2uuBICYXIT
    servant-client-0.20.2-2WKVogshu1I6PdY1ciGPf4
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    tar-conduit-0.4.1-EGPGFFDtXlmKVJDP8Pq64n template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

