#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.3
visibility:           public
id:                   arch-hs-0.12.0.3-8J60dhP6j9s1p55FzhAvdq
key:                  arch-hs-0.12.0.3-8J60dhP6j9s1p55FzhAvdq
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  d48c9c7eb009a881051d4aa7733cb91c
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.3-8J60dhP6j9s1p55FzhAvdq
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-E4QQdwFPhVj2ic4COxhZBq
    aeson-2.1.2.1-6LfdTurWC20A9IWYLs821k
    algebraic-graphs-0.7-KrC6xREe0U83I6X0X1QOGr
    arch-web-0.3.1-7eR0iuOL9lC8QVQBbNzkxT base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-EVJ10prSzIP4i22LIWcNGH
    conduit-extra-1.3.8-6X110wJXrg3AO7uiFEQyud containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-4M4KFWGNvcIv2tjkSm9vt
    http-client-0.7.18-9qBJxh17yshDwYABVFlZAq
    http-client-tls-0.3.6.4-BmU0JwWls2VKjAI6YrsjSE
    megaparsec-9.7.0-8pqi9iESDeArTxKEjGQsn
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-DhWteye0bz4KJhv9gp84bw
    optparse-simple-0.1.1.4-7aalDDepohB1iyk7UJxeza
    polysemy-1.9.2.0-I5J9UjC6Y2Q8P3jnVQCkN6
    prettyprinter-1.7.1-OSddR9QU1LKvWd60o7pju
    prettyprinter-ansi-terminal-1.1.3-32HfLtjcgVL9wxVBnHPent
    servant-client-0.20.2-OIWuyLky4W6lckFtVz9nl
    split-0.2.5-8TDPZlIHK1VKb3LgCQDYep
    tar-conduit-0.4.1-6Mg63fmiBfa4e8U5LV6JxJ template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

