#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.3
visibility:           public
id:                   arch-hs-0.12.0.3-2xlw9990duqC783rE3Lx7b
key:                  arch-hs-0.12.0.3-2xlw9990duqC783rE3Lx7b
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  79a3a363f5656160f12b03a9448fb3ba
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.3-2xlw9990duqC783rE3Lx7b
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-7Fwvr1SqYTt4uBZ7hvolZA
    aeson-2.1.2.1-8gRdOgbBkF57DAEniCzHis
    algebraic-graphs-0.7-GGE6YKqRsnbLIcTtKsFvS8
    arch-web-0.3.1-Edj6lXcGwb3EmElRJMfz8j base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-EEoD2QArhRxFbtxrlaKgkd
    conduit-extra-1.3.8-4vGcjD1RnCr9zclEb4aEgy containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-LYpgb44Kg6OC3tS9bAlJGK
    http-client-0.7.18-1ilMUdfjVEzBmOQGNnAaP8
    http-client-tls-0.3.6.4-8dChSegNH5N3bDZSPplmBY
    megaparsec-9.6.1-EEBj4pRLerNCeJDumClMn7
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-Lhsj0pZV5W4685pSRQNPFH
    optparse-simple-0.1.1.4-8geJfJfHrVG5VZu7ni5iN0
    polysemy-1.9.2.0-AyiXdvKLbU9B3lA2cvvRJY
    prettyprinter-1.7.1-H0iQpJbBZ6k9IFy5REj5dh
    prettyprinter-ansi-terminal-1.1.3-FhScSTfQH45372MjCmeGhc
    servant-client-0.20.2-AnlqhIRkltSJ0RdjtK2pG6
    split-0.2.5-B9q8eJqGWtOKQzzX1ITTGf
    tar-conduit-0.4.1-cJGXlHDhYDIyWuDLKh6qu template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

