#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.3
visibility:           public
id:                   arch-hs-0.12.0.3-CDYin3AEXgW6TeHQbrnWsw
key:                  arch-hs-0.12.0.3-CDYin3AEXgW6TeHQbrnWsw
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  920d80861414b69c163733e0a451ffa8
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.3-CDYin3AEXgW6TeHQbrnWsw
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-4VjaazPwKkA8eC2BQCP8tm
    aeson-2.1.2.1-4cRYi3WcVwTKRqMhXUztfB
    algebraic-graphs-0.7-CNhOgCj0LIo5Vra3PahqdA
    arch-web-0.3.1-Kyie1LleDPc39kq9ILlsAf base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-KZNeLPeXvjD5EEhRbg4Ht8
    conduit-extra-1.3.8-Gwq2qlVhV3jEWryL83GuOP containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-2eOl6ygVcM12AXdoASVXnl
    http-client-0.7.18-IsbH9OAm6XgF9hL4xsUtLO
    http-client-tls-0.3.6.4-AbKaWsrN8o1Gmv354Xqd1x
    megaparsec-9.6.1-GErkrd4BuZw1o2z4Ja9YFU
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-GZoZLsk9FUC2zhAh8dUNBt
    optparse-simple-0.1.1.4-25gOjoPGtdL2am9L9ihSYn
    polysemy-1.9.2.0-GEF3MAGMRHD4w9dH61aVcP
    prettyprinter-1.7.1-G4E3PI2BTIHFT7NfmJKOqD
    prettyprinter-ansi-terminal-1.1.3-FHReNHhiJ9k22dC6VcAYKN
    servant-client-0.20.2-39dzBHEZCdoHRAgyhXP2Da
    split-0.2.5-JeJxVdKJRKMda8iubaxqh
    tar-conduit-0.4.1-FUH1ctbuLzj9AXAo5CW1zN template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

