#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 Allure
version:              0.11.0.0
visibility:           public
id:                   Allure-0.11.0.0-LKghm5z1YlsLK6oGvksuqL
key:                  Allure-0.11.0.0-LKghm5z1YlsLK6oGvksuqL
license:              AGPL-3.0-or-later
maintainer:           Mikolaj Konarski <mikolaj.konarski@funktory.com>
author:               Andres Loeh, Mikolaj Konarski and others
homepage:             http://allureofthestars.com
synopsis:             Near-future Sci-Fi roguelike and tactical squad combat game
description:
    Allure of the Stars is a near-future Sci-Fi roguelike
    and tactical squad combat game. Binaries and the game manual
    are available at the homepage. You can also try the game out
    in the browser at <http://allureofthestars.com/play>.

    Not a single image in this game. You have to imagine everything
    yourself, like with a book (a grown-up book, without pictures).
    Once you learn to imagine things, though, you can keep exploring
    and mastering the world and making up stories for a long time.

    The game is written in Haskell using the LambdaHack roguelike
    game engine <http://hackage.haskell.org/package/LambdaHack>.
    Please see the changelog file for recent improvements
    and the issue tracker for short-term plans. Long term goals
    are high replayability and auto-balancing through procedural
    content generation and persistent content modification
    based on player behaviour. Contributions are welcome.

    This is a workaround .cabal file, flattened to eliminate
    internal libraries until generating haddocks for them
    is fixed. The original .cabal file is in .cabal.bkp file.

category:             Game
abi:                  54f357114de0f0e96c901cf4710892ce
exposed:              True
exposed-modules:
    Client.UI.Content.Input Client.UI.Content.Screen Content.CaveKind
    Content.FactionKind Content.ItemKind Content.ItemKindActor
    Content.ItemKindBlast Content.ItemKindEmbed Content.ItemKindOrgan
    Content.ItemKindTemporary Content.ModeKind Content.PlaceKind
    Content.RuleKind Content.TileKind
    Implementation.MonadClientImplementation
    Implementation.MonadServerImplementation TieKnot

hidden-modules:       Paths_Allure
import-dirs:          /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/allure
hs-libraries:         HSAllure-0.11.0.0-LKghm5z1YlsLK6oGvksuqL
depends:
    LambdaHack-0.11.0.1-LfALoZa9kFhFWemW2govRK
    async-2.2.5-EP91qAI3cOI8P3d6QWskI6 base-4.17.2.1
    enummapset-0.7.3.0-An2oRLX2NsHDaOoRl68IYD
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    ghc-compact-0.1.0.0 hsini-0.5.2.2-BDbP6FZ9ea1CMlYdtOBEDC
    optparse-applicative-0.18.1.0-DIJ4MbtGu3QDLh3tqkvHS0
    primitive-0.9.1.0-8f7NBHiHFdgFE3qTf44BEn
    splitmix-0.1.2-HmPeXZq1nIeLLcwCjPixin template-haskell-2.19.0.0
    text-2.0.2 th-lift-instances-0.1.20-I3Yv3ray6hoCM5U3aug8iT
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/allure/html/Allure.haddock
haddock-html:         /usr/share/doc/allure/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

