#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 Allure
version:              0.11.0.0
visibility:           public
id:                   Allure-0.11.0.0-I31a99My9S87oeRl7We8Lw
key:                  Allure-0.11.0.0-I31a99My9S87oeRl7We8Lw
license:              AGPL-3.0-or-later
maintainer:           Mikolaj Konarski <mikolaj.konarski@funktory.com>
author:               Andres Loeh, Mikolaj Konarski and others
homepage:             http://allureofthestars.com
synopsis:             Near-future Sci-Fi roguelike and tactical squad combat game
description:
    Allure of the Stars is a near-future Sci-Fi roguelike
    and tactical squad combat game. Binaries and the game manual
    are available at the homepage. You can also try the game out
    in the browser at <http://allureofthestars.com/play>.

    Not a single image in this game. You have to imagine everything
    yourself, like with a book (a grown-up book, without pictures).
    Once you learn to imagine things, though, you can keep exploring
    and mastering the world and making up stories for a long time.

    The game is written in Haskell using the LambdaHack roguelike
    game engine <http://hackage.haskell.org/package/LambdaHack>.
    Please see the changelog file for recent improvements
    and the issue tracker for short-term plans. Long term goals
    are high replayability and auto-balancing through procedural
    content generation and persistent content modification
    based on player behaviour. Contributions are welcome.

    This is a workaround .cabal file, flattened to eliminate
    internal libraries until generating haddocks for them
    is fixed. The original .cabal file is in .cabal.bkp file.

category:             Game
abi:                  aded1bb3382b56075245d12dccf19f22
exposed:              True
exposed-modules:
    Client.UI.Content.Input Client.UI.Content.Screen Content.CaveKind
    Content.FactionKind Content.ItemKind Content.ItemKindActor
    Content.ItemKindBlast Content.ItemKindEmbed Content.ItemKindOrgan
    Content.ItemKindTemporary Content.ModeKind Content.PlaceKind
    Content.RuleKind Content.TileKind
    Implementation.MonadClientImplementation
    Implementation.MonadServerImplementation TieKnot

hidden-modules:       Paths_Allure
import-dirs:          /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/allure
hs-libraries:         HSAllure-0.11.0.0-I31a99My9S87oeRl7We8Lw
depends:
    LambdaHack-0.11.0.1-BsvPVlM82HaLN8VsyIag3v
    async-2.2.5-1z0oB69LG2FBRno1il1zoZ base-4.17.2.1
    enummapset-0.7.3.0-qJPUUsvEmwLbKmPTGcCTS
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    ghc-compact-0.1.0.0 hsini-0.5.2.2-5s4mD88HCxBIn6JDrSsJNo
    optparse-applicative-0.18.1.0-Ebh0I8Iojv3DBRdzITzz2E
    primitive-0.9.1.0-GChnkqMWBe7B15Z0K3IGlf
    splitmix-0.1.1-2v6KpeX3xvuAouXBHztuEW template-haskell-2.19.0.0
    text-2.0.2 th-lift-instances-0.1.20-BZt5ACsDMY78PKpzLsklHT
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/allure/html/Allure.haddock
haddock-html:         /usr/share/doc/allure/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

